/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.query.core;

import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.common.core.builder.IModiscoBuilder;

public class QueryBuilder implements IModiscoBuilder {

	protected static final String FILE_EXTENSION = "querySet"; //$NON-NLS-1$

	public IProject[] build(final IncrementalProjectBuilder builder,
			final int kind, final Map<?, ?> args, final IProgressMonitor monitor)
			throws CoreException {
		if (kind == IncrementalProjectBuilder.FULL_BUILD) {
			fullBuild(builder);
		} else {
			IProject project = builder.getProject();
			IResourceDelta delta = builder.getDelta(project);
			if (delta == null) {
				fullBuild(builder);
			} else {
				incrementalBuild(builder, delta);
			}
		}
		return null;
	}

	private void incrementalBuild(final IncrementalProjectBuilder builder,
			final IResourceDelta iResourceDelta) {
		try {
			iResourceDelta.accept(new IResourceDeltaVisitor() {
				public boolean visit(final IResourceDelta delta) {

					IResource resource = delta.getResource();
					String fileExtension = resource.getFileExtension();
					if (resource instanceof IFile
							&& fileExtension != null
							&& fileExtension
									.equals(QueryBuilder.FILE_EXTENSION)) {
						switch (delta.getKind()) {
						case IResourceDelta.ADDED:
							ModelQuerySetCatalog.getSingleton().addWSFile(
									(IFile) resource);
							break;
						case IResourceDelta.REMOVED:
							ModelQuerySetCatalog.getSingleton().removeWSFile(
									(IFile) resource);
							break;
						case IResourceDelta.CHANGED:
							ModelQuerySetCatalog.getSingleton().removeWSFile(
									(IFile) resource);
							ModelQuerySetCatalog.getSingleton().addWSFile(
									(IFile) resource);
							break;
						case IResourceDelta.ADDED_PHANTOM:
							ModelQuerySetCatalog.getSingleton().addWSFile(
									(IFile) resource);
							break;
						case IResourceDelta.REMOVED_PHANTOM:
							ModelQuerySetCatalog.getSingleton().removeWSFile(
									(IFile) resource);
							break;
						default:
							IStatus status = new Status(IStatus.ERROR,
									Activator.PLUGIN_ID, "Unknown delta kind: " //$NON-NLS-1$
											+ delta.getKind(), new Exception());
							Activator.getDefault().getLog().log(status);
							break;
						}
					}
					return true;
				}
			});
		} catch (CoreException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
					"Failed to build: " + builder.getProject(), e); //$NON-NLS-1$
			Activator.getDefault().getLog().log(status);
		}
	}

	private void fullBuild(final IncrementalProjectBuilder builder) {
		try {
			builder.getProject().accept(new IResourceVisitor() {
				public boolean visit(final IResource resource)
						throws CoreException {
					String fileExtension = resource.getFileExtension();
					if (fileExtension != null
							&& fileExtension
									.equals(QueryBuilder.FILE_EXTENSION)) {
						try {
							ModelQuerySetCatalog.getSingleton().addWSFile(
									(IFile) resource);
						} catch (ClassCastException e) {
							IStatus status = new Status(IStatus.ERROR,
									Activator.PLUGIN_ID, "Failed to build: " //$NON-NLS-1$
											+ resource.getProject().getName(),
									e);
							Activator.getDefault().getLog().log(status);
						}
					}
					return true;
				}
			});
		} catch (CoreException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
					"Failed to build: " + builder.getProject(), e); //$NON-NLS-1$
			Activator.getDefault().getLog().log(status);
		}
	}

	public void clean(final IncrementalProjectBuilder builder,
			final IProgressMonitor monitor) throws CoreException {
		try {
			builder.getProject().accept(new IResourceVisitor() {
				public boolean visit(final IResource resource)
						throws CoreException {
					boolean continueValue = true;
					if (resource instanceof IProject) {
						ModelQuerySetCatalog.getSingleton().clean(
								(IProject) resource);
						continueValue = false;
					}
					return continueValue;
				}
			});
		} catch (CoreException e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
					"Failed to clean: " + builder.getProject(), e); //$NON-NLS-1$
			Activator.getDefault().getLog().log(status);
		}
	}
}
