/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.query.core.java;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.common.core.CommonModiscoActivator;
import org.eclipse.gmt.modisco.common.core.builder.EcoreCatalog;
import org.eclipse.gmt.modisco.common.core.resource.MoDiscoResourceSet;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.QueryPackage;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.Activator;
import org.eclipse.gmt.modisco.infra.query.core.IModelQueryFactory;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JavaModelQueryFactory implements IModelQueryFactory {

	private static IResourceChangeListener changeListner;
	private static HashMap<IProject, Bundle> bundleMap = new HashMap<IProject, Bundle>();

	public JavaModelQueryFactory() {
		if (JavaModelQueryFactory.changeListner == null) {
			JavaModelQueryFactory.changeListner = JavaModelQueryFactory
					.initChangeListener();
		}
	}

	public AbstractModelQuery create(final ModelQuery modelQuery,
			final Bundle bundle) throws ModelQueryException {
		if (!(modelQuery instanceof JavaModelQuery)) {
			ModelQueryException e = new ModelQueryException(
					"Wrong kind of modelQuery: " //$NON-NLS-1$
							+ modelQuery.getClass().getSimpleName() + "found, " //$NON-NLS-1$
							+ JavaModelQuery.class.getSimpleName()
							+ "expected."); //$NON-NLS-1$
			throw e;
		}
		AbstractModelQuery javaModelQueryInst = null;
		try {
			Bundle localBundle;
			JavaModelQuery javaModelQuery = (JavaModelQuery) modelQuery;
			if (bundle == null) {
				IWorkspace ws = ResourcesPlugin.getWorkspace();
				URI uri = ModelQuerySetCatalog.getSingleton().getURI(
						modelQuery.getModelQuerySet().getName());
				String fileString = uri.toPlatformString(true);
				IResource file = ws.getRoot().findMember(new Path(fileString));
				IProject project = file.getProject();
				localBundle = JavaModelQueryFactory.bundleMap.get(project);
				if (localBundle == null) {
					localBundle = Activator.getDefault().installBunble(project);
					searchPluginXml(project, localBundle);
					JavaModelQueryFactory.bundleMap.put(project, localBundle);
					JavaModelQuery oldJavaModelQuery = javaModelQuery;
					javaModelQuery = (JavaModelQuery) ModelQuerySetCatalog
							.getSingleton()
							.getModelQuerySet(
									javaModelQuery.getModelQuerySet().getName())
							.getQuery(javaModelQuery.getName());
				}
			} else {
				localBundle = bundle;
			}
			String className = javaModelQuery.getImplementationClassName();
			if (className == null || className.length() == 0) {
				throw new ModelQueryExecutionException(
						"implementationClassName is empty"); //$NON-NLS-1$
			}
			Class<?> javaModelQueryClass = localBundle.loadClass(className);
			boolean found = false;
			for (Class<?> c : javaModelQueryClass.getInterfaces()) {
				if (IJavaModelQuery.class == c) {
					found = true;
					break;
				}
			}
			if (!found) {
				Exception e = new Exception(className + " does not implement " //$NON-NLS-1$
						+ IJavaModelQuery.class.getSimpleName() + "."); //$NON-NLS-1$
				throw e;
			}
			javaModelQueryInst = createJavaModelQueryImpl(javaModelQuery,
					javaModelQueryClass);
			javaModelQueryInst.setCheckResult(bundle != null);
		} catch (Exception e) {
			ModelQueryException mqe = new ModelQueryException(
					"Failed to load the model query: " //$NON-NLS-1$
							+ modelQuery.getModelQuerySet().getName() + "::" //$NON-NLS-1$
							+ modelQuery.getName(), e);
			Status status = new Status(IStatus.ERROR, Activator.PLUGIN_ID, mqe
					.getMessage(), mqe);
			Activator.getDefault().getLog().log(status);
			throw mqe;
		}
		return javaModelQueryInst;
	}

	/**
	 * This methods is dedicated to isolate the "Unchecked cast" warning.
	 * 
	 * @param javaModelQuery
	 * @param javaModelQueryClass
	 * @return
	 * @throws NoSuchMethodException
	 * @throws SecurityException
	 * @throws InvocationTargetException
	 * @throws IllegalAccessException
	 * @throws InstantiationException
	 * @throws IllegalArgumentException
	 */
	// @SuppressWarnings("unchecked")
	private AbstractModelQuery createJavaModelQueryImpl(
			final JavaModelQuery javaModelQuery,
			final Class<?> javaModelQueryClass) throws NoSuchMethodException,
			InstantiationException, IllegalAccessException,
			InvocationTargetException {
		IJavaModelQuery javaModelQueryInst;
		javaModelQueryInst = (IJavaModelQuery) javaModelQueryClass
				.newInstance();
		AbstractModelQuery adapter = new JavaModelQueryAdapter(javaModelQuery,
				javaModelQueryInst);
		return adapter;
	}

	public EClass getManagedModelQueryType() {
		return QueryPackage.eINSTANCE.getJavaModelQuery();
	}

	static HashMap<IProject, Bundle> getBundleMap() {
		return JavaModelQueryFactory.bundleMap;
	}

	private static IResourceChangeListener initChangeListener() {
		IWorkspace workspace = ResourcesPlugin.getWorkspace();
		IResourceChangeListener listener = new IResourceChangeListener() {
			public void resourceChanged(final IResourceChangeEvent event) {
				if (event != null) {
					chekDelta(event.getDelta());
				}
			}

			private void chekDelta(final IResourceDelta delta) {
				if (delta != null) {
					for (IResourceDelta subdelta : delta.getAffectedChildren()) {
						chekDelta(subdelta);
					}

					IResource resource = delta.getResource();
					if (resource != null) {
						IProject project = resource.getProject();
						Set<IProject> listened = JavaModelQueryFactory
								.getBundleMap().keySet();
						if (listened.contains(project)) {
							if ("class".equals(resource.getFileExtension())) { //$NON-NLS-1$
								if (project.getLocation() != null) {
									JavaModelQueryFactory.getBundleMap()
											.remove(project);
								}
							}
						}
					}
				}
			}
		};
		workspace.addResourceChangeListener(listener);
		return listener;
		// workspace.removeResourceChangeListener(listener);
	}

	@Deprecated
	EPackage searchPluginXml(final String uri, final IFile declarationFile)
			throws IOException, ParserConfigurationException, SAXException,
			ClassNotFoundException, NoSuchFieldException,
			IllegalAccessException {
		IFile pluginFile = declarationFile.getProject().getFile("plugin.xml"); //$NON-NLS-1$
		EPackage result = null;
		if (pluginFile.exists()) {
			Handler2 handler = new Handler2(declarationFile, uri);
			parse(new FileInputStream(pluginFile.getLocation().toFile()),
					Collections.EMPTY_MAP, handler);
			result = handler.getEPackage();
		}
		return result;
	}

	void searchPluginXml(final IProject project, final Bundle bundle)
			throws IOException, ParserConfigurationException, SAXException {
		IFile pluginFile = project.getFile("plugin.xml"); //$NON-NLS-1$
		if (pluginFile.exists()) {
			Handler handler = new Handler();
			parse(new FileInputStream(pluginFile.getLocation().toFile()),
					Collections.EMPTY_MAP, handler);
			handler.getEPackages(bundle);
		}
	}

	/**
	 * This method has been copied from
	 * org.eclipse.gmt.modisco.xml.discoverer.resource.GenericXMLResourceImpl()
	 * 
	 * @author Fabien Giquel (Mia-Software)
	 * @author Grgoire Dup (Mia-Software)
	 * @param fileInputStream
	 * @param options
	 * @throws IOException
	 * @throws SAXException
	 * @throws ParserConfigurationException
	 */
	private final void parse(final FileInputStream fileInputStream,
			final Map<?, ?> options, final DefaultHandler handler)
			throws IOException, ParserConfigurationException, SAXException {
		SAXParserFactory f = SAXParserFactory.newInstance();
		f.setValidating(false);
		SAXParser p = f.newSAXParser();
		XMLReader reader = p.getXMLReader();
		try {
			reader
					.setFeature(
							"http://apache.org/xml/features/nonvalidating/load-external-dtd", //$NON-NLS-1$
							false);
		} catch (SAXNotRecognizedException e) {
			// go on without this feature,
			// UnknownHostException may occur when
			// a external dtd is indicated
			// but not accessible (e.g. if www is not available)
		}
		p.parse(fileInputStream, handler);
	}

	public class Handler extends DefaultHandler {

		private boolean isInGPExtension = false;
		private List<EPackageDescription> ePackageDescriptions = new ArrayList<EPackageDescription>();

		public void getEPackages(final Bundle bundle) {
			if (this.ePackageDescriptions.size() > 0) {
				// for (EPackageDescription epackDescription :
				// this.ePackageDescriptions) {
				// epackDescription.removeEPackage();
				// }
				// Bundle bundle = Activator.getDefault().installBunble(
				// this.project);
				for (EPackageDescription epackDescription : this.ePackageDescriptions) {
					EPackage ePackage = epackDescription.getEPackage(bundle);
					MoDiscoResourceSet.getResourceSetSingleton()
							.aResourceHasBeenLoaded(ePackage.eResource());
				}
			}
		}

		private class EPackageDescription {

			private String className;
			private String nsUri;

			public EPackageDescription(final String nsUri,
					final String classString) {
				this.className = classString;
				this.nsUri = nsUri;
			}

			public EPackage getEPackage(final Bundle bundle) {
				EPackage ePackage = null;
				try {
					if (this.className != null && this.nsUri != null) {
						// TODO sans doute inutile
						// try {
						// ePackage = EPackage.Registry.INSTANCE
						// .getEPackage(this.nsUri);
						// } catch (Exception e) {
						// IStatus status2 = new Status(IStatus.WARNING,
						// CommonModiscoActivator.PLUGIN_ID,
						// "Failed to get the ePackage: " + this.nsUri);
						// Activator.getDefault().getLog().log(status2);
						// }
						// if (ePackage == null) {
						Class<?> ePackageClass = bundle
								.loadClass(this.className);
						Field instanceField = ePackageClass
								.getField("eINSTANCE"); //$NON-NLS-1$
						ePackage = (EPackage) instanceField.get(null);
						EPackage.Registry.INSTANCE.put(ePackage.getNsURI(),
								ePackage);
						// }
					}
				} catch (Exception e) {
					IStatus status2 = new Status(IStatus.ERROR,
							CommonModiscoActivator.PLUGIN_ID,
							"Failed to load an ePackage: " + this.nsUri); //$NON-NLS-1$
					Activator.getDefault().getLog().log(status2);
				}
				return ePackage;

			}
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void startElement(final String uri, final String localname,
				final String qname, final Attributes attributes)
				throws SAXException {
			if (qname.equals("extension")) { //$NON-NLS-1$
				for (int i = 0; i < attributes.getLength(); i++) {
					if (attributes.getLocalName(i).equals("point")) { //$NON-NLS-1$
						if (attributes.getValue(i).equals(
								"org.eclipse.emf.ecore.generated_package")) { //$NON-NLS-1$
							this.isInGPExtension = true;
							break;
						}
					}
				}
			} else if (this.isInGPExtension && qname.equals("package")) { //$NON-NLS-1$
				String nsUri = null;
				String classString = null;
				for (int i = 0; i < attributes.getLength(); i++) {
					if (attributes.getLocalName(i).equals("uri")) { //$NON-NLS-1$
						nsUri = attributes.getValue(i);
					} else if (attributes.getLocalName(i).equals("class")) { //$NON-NLS-1$
						classString = attributes.getValue(i);
					}
				}
				this.ePackageDescriptions.add(new EPackageDescription(nsUri,
						classString));

			}
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void endElement(final String uri, final String localname,
				final String qName) throws SAXException {
			if (localname.equals("extension")) { //$NON-NLS-1$
				this.isInGPExtension = false;
			}
		}
	}

	@Deprecated
	private class Handler2 extends DefaultHandler implements BundleListener {

		private String className = null;
		private EPackage ePackage = null;
		private boolean isInGPExtension = false;
		private IProject project;
		private String nsUriToFound;
		private IFile declarationFile;
		private String bundleName;

		/**
		 * @param project
		 */
		public Handler2(final IFile declarationFile, final String nsURI) {
			this.declarationFile = declarationFile;
			this.project = declarationFile.getProject();
			this.nsUriToFound = nsURI;
		}

		/**
		 * @param nsUri
		 * @param classString
		 * @throws ClassNotFoundException
		 * @throws NoSuchFieldException
		 * @throws SecurityException
		 * @throws IllegalAccessException
		 * @throws IllegalArgumentException
		 */
		public EPackage getEPackage() throws ClassNotFoundException,
				NoSuchFieldException, IllegalAccessException {
			if (this.className != null) {
				EPackage.Registry.INSTANCE.remove(this.nsUriToFound);
				Bundle bundle = Activator.getDefault().installBunble(
						this.project);
				// TODO sans soute inutile
				try {
					this.ePackage = EPackage.Registry.INSTANCE
							.getEPackage(this.nsUriToFound);
				} catch (Exception e) {
					IStatus status2 = new Status(IStatus.WARNING,
							CommonModiscoActivator.PLUGIN_ID,
							"Failed to get the ePackage: " + this.nsUriToFound); //$NON-NLS-1$
					Activator.getDefault().getLog().log(status2);
				}
				if (this.ePackage == null) {
					Class<?> ePackageClass = bundle.loadClass(this.className);
					Field instanceField = ePackageClass.getField("eINSTANCE"); //$NON-NLS-1$
					this.ePackage = (EPackage) instanceField.get(null);
					EPackage.Registry.INSTANCE.put(this.ePackage.getNsURI(),
							this.ePackage);
				}
				this.bundleName = bundle.getSymbolicName();
				bundle.getBundleContext().addBundleListener(this);
			}
			return this.ePackage;
		}

		public void bundleChanged(final BundleEvent event) {

			try {
				if (event.getBundle().getSymbolicName().equals(this.bundleName)) {
					IStatus status = new Status(IStatus.INFO,
							Activator.PLUGIN_ID, "Bundle change detected: " //$NON-NLS-1$
									+ event.getBundle().getSymbolicName());
					Activator.getDefault().getLog().log(status);
					EcoreCatalog.getSingleton().addWSFile(this.declarationFile);
				}
			} catch (Exception e) {
				IStatus status2 = new Status(IStatus.ERROR,
						Activator.PLUGIN_ID, e.getMessage(), e);
				Activator.getDefault().getLog().log(status2);
			}
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void startElement(final String uri, final String localname,
				final String qname, final Attributes attributes)
				throws SAXException {
			if (qname.equals("extension")) { //$NON-NLS-1$
				for (int i = 0; i < attributes.getLength(); i++) {
					if (attributes.getLocalName(i).equals("point")) { //$NON-NLS-1$
						if (attributes.getValue(i).equals(
								"org.eclipse.emf.ecore.generated_package")) { //$NON-NLS-1$
							this.isInGPExtension = true;
							break;
						}
					}
				}
			} else if (this.isInGPExtension && qname.equals("package")) { //$NON-NLS-1$
				String nsUri = null;
				String classString = null;
				for (int i = 0; i < attributes.getLength(); i++) {
					if (attributes.getLocalName(i).equals("uri")) { //$NON-NLS-1$
						nsUri = attributes.getValue(i);
					} else if (attributes.getLocalName(i).equals("class")) { //$NON-NLS-1$
						classString = attributes.getValue(i);
					}
				}
				if (this.nsUriToFound.equals(nsUri)) {
					try {
						this.className = classString;
					} catch (Exception e) {
						IStatus status = new Status(IStatus.ERROR,
								CommonModiscoActivator.PLUGIN_ID, e
										.getMessage(), e);
						Activator.getDefault().getLog().log(status);
					}
				}
			}
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void endElement(final String uri, final String localname,
				final String qName) throws SAXException {
			if (localname.equals("extension")) { //$NON-NLS-1$
				this.isInGPExtension = false;
			}
		}
	}
}
