/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugues Dubourg (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.kdm.uml2converter.popup.actions;

import java.util.logging.Logger;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUmlConverterInterface;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public class Convert implements IObjectActionDelegate {

	protected final Logger logger = Logger.getLogger(ATLLogger.LOGGER_ID);
	protected IFile kdmFile;
	private IWorkbenchPart workbench;
	
	/**
	 * Constructor for Action1.
	 */
	public Convert() {
		super();
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.workbench = targetPart;
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {		
		final String kdmModelPath = this.kdmFile.getLocation().toString();
		final IPath umlModelPath = this.kdmFile.getLocation().removeFileExtension().addFileExtension("uml"); //$NON-NLS-1$
		
		Job job = new Job(Messages.Convert_0 + umlModelPath.lastSegment()) {
			
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				IStatus result = null;
				AtlLogHandler logHandler = new AtlLogHandler(umlModelPath.toString() + ".log"); //$NON-NLS-1$
				Convert.this.logger.addHandler(logHandler);
				try{
					KdmToUmlConverterInterface transfo = new KDMtoUML2Converter();
					Resource kdmModel = new XMIResourceImpl();
					kdmModel.setURI(URI.createFileURI(kdmModelPath));
					URI outputURI = URI.createFileURI(umlModelPath.toString());
					
					transfo.getUML2ModelFromKDMModel(kdmModel, false, outputURI);
					
					result = Status.OK_STATUS;
				}catch (Exception e) {
					result = Status.CANCEL_STATUS;
				} finally {
					Convert.this.logger.removeHandler(logHandler);
					logHandler.close();
					try {
						Convert.this.kdmFile.getParent().refreshLocal(1, null);
					} catch (Exception e1) {
						//give up
					}
				}
				return result;
			}
		};
		
		//triggers opening of the uml model as soon as it is saved
		job.addJobChangeListener(new JobChangeAdapter() {
			public void done(IJobChangeEvent event) {
				//access UI resources so that we can obtain the current eclipse workbench activePage
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						try {
							IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
							IFile ifile = root.getFileForLocation(umlModelPath);
							if (ifile.exists()) {
								IWorkbenchPage page = Convert.this.workbench.getSite().getPage();
								//programmatically opens the uml model using default editor
								IDE.openEditor(page, ifile);
							}
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		
		job.schedule();
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		this.kdmFile = (IFile)((IStructuredSelection)selection).getFirstElement();
	}

}