/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Frederic MADIOT (Mia-Software) - meta-model design
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.infra.role;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Set</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.infra.role.RoleSet#getExtendedPackage <em>Extended Package</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.infra.role.RoleSet#getRoles <em>Roles</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.gmt.modisco.infra.role.RolePackage#getRoleSet()
 * @model
 * @generated
 */
public interface RoleSet extends EPackage {
	/**
	 * Returns the value of the '<em><b>Extended Package</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Extended Package</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Extended Package</em>' reference.
	 * @see #setExtendedPackage(EPackage)
	 * @see org.eclipse.gmt.modisco.infra.role.RolePackage#getRoleSet_ExtendedPackage()
	 * @model required="true"
	 * @generated
	 */
	EPackage getExtendedPackage();

	/**
	 * Sets the value of the '{@link org.eclipse.gmt.modisco.infra.role.RoleSet#getExtendedPackage <em>Extended Package</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Extended Package</em>' reference.
	 * @see #getExtendedPackage()
	 * @generated
	 */
	void setExtendedPackage(EPackage value);

	/**
	 * Returns the value of the '<em><b>Roles</b></em>' reference list. The list
	 * contents are of type {@link org.eclipse.gmt.modisco.infra.role.Role}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Roles</em>' reference isn't clear, there
	 * really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Roles</em>' reference list.
	 * @see #isSetRoles()
	 * @see #unsetRoles()
	 * @see org.eclipse.gmt.modisco.infra.role.RolePackage#getRoleSet_Roles()
	 * @model unsettable="true" volatile="true" derived="true"
	 * @generated
	 */
	EList<Role> getRoles();

	/**
	 * Unsets the value of the '{@link org.eclipse.gmt.modisco.infra.role.RoleSet#getRoles <em>Roles</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetRoles()
	 * @see #getRoles()
	 * @generated
	 */
	void unsetRoles();

	/**
	 * Returns whether the value of the '{@link org.eclipse.gmt.modisco.infra.role.RoleSet#getRoles <em>Roles</em>}' reference list is set.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return whether the value of the '<em>Roles</em>' reference list is set.
	 * @see #unsetRoles()
	 * @see #getRoles()
	 * @generated
	 */
	boolean isSetRoles();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	Role getRole(String name);

} // RoleSet
