/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Frederic MADIOT (Mia-Software) - meta-model design
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.infra.role.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RolePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Role</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.infra.role.impl.RoleImpl#getConditionQuery <em>Condition Query</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RoleImpl extends EClassImpl implements Role {
	/**
	 * The cached value of the '{@link #getConditionQuery() <em>Condition Query</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConditionQuery()
	 * @generated
	 * @ordered
	 */
	protected ModelQuery conditionQuery;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RoleImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return RolePackage.Literals.ROLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQuery getConditionQuery() {
		if (conditionQuery != null && conditionQuery.eIsProxy()) {
			InternalEObject oldConditionQuery = (InternalEObject)conditionQuery;
			conditionQuery = (ModelQuery)eResolveProxy(oldConditionQuery);
			if (conditionQuery != oldConditionQuery) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, RolePackage.ROLE__CONDITION_QUERY, oldConditionQuery, conditionQuery));
			}
		}
		return conditionQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQuery basicGetConditionQuery() {
		return conditionQuery;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConditionQuery(ModelQuery newConditionQuery) {
		ModelQuery oldConditionQuery = conditionQuery;
		conditionQuery = newConditionQuery;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RolePackage.ROLE__CONDITION_QUERY, oldConditionQuery, conditionQuery));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case RolePackage.ROLE__CONDITION_QUERY:
				if (resolve) return getConditionQuery();
				return basicGetConditionQuery();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case RolePackage.ROLE__CONDITION_QUERY:
				setConditionQuery((ModelQuery)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case RolePackage.ROLE__CONDITION_QUERY:
				setConditionQuery((ModelQuery)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case RolePackage.ROLE__CONDITION_QUERY:
				return conditionQuery != null;
		}
		return super.eIsSet(featureID);
	}

} //RoleImpl
