/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.role.validation;

import java.util.List;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.plugin.RolePlugin;

public class ExtendedClassValidation extends AbstractModelConstraint {

	@Override
	public IStatus validate(final IValidationContext ctx) {
		EObject eObject = ctx.getTarget();
		EMFEventType eType = ctx.getEventType();
		try {
			IStatus result = null;
			if (eType == EMFEventType.NULL) {
				Role role = (Role) eObject;
				List<EClass> superTypes = role.getESuperTypes();
				for (EClass superType : superTypes) {
					boolean found = superType.getEPackage().getNsURI().equals(
							EcorePackage.eINSTANCE.getNsURI());
					EPackage ePackage = ((RoleSet) role.getEPackage())
							.getExtendedPackage();
					if (ePackage.getEClassifiers().contains(superType)) {
						found = true;
					}
					if (found) {
						result = ctx.createSuccessStatus();
					} else {
						result = ctx.createFailureStatus(superType.getName(),
								role.getName());
						break;
					}
				}
			} else {
				result = ctx.createSuccessStatus();
			}
			return result;
		} catch (NullPointerException e) {
			IStatus status = new Status(IStatus.WARNING,
					RolePlugin.PLUGIN_ID, "Unexpected null value in " //$NON-NLS-1$
							+ eObject.eResource().getURI().toString(), e);
			RolePlugin.getDefault().getLog().log(status);
			return ctx.createSuccessStatus();
		}
	}
}
