/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire Dupe (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.discoverer.tests.cdo.server;

import java.util.Map;

import javax.sql.DataSource;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IRevisionManager;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gmt.modisco.java.discoverer.tests.Activator;
import org.eclipse.gmt.modisco.java.discoverer.tests.Server;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public abstract class AbstractCDOServer implements Server {

	protected static final Integer CURRENT_LRU_CAPACITY = 100000;
	protected static final Integer REVISED_LRU_CAPACITY = 10000;
	private static final String DB_NAME_PREFIX = "db"; //$NON-NLS-1$
	private static final int PORT = 2036;
	public static final String REPOSITORY_NAME = "repo1"; //$NON-NLS-1$
	public static final String HOSTNAME = "localhost"; //$NON-NLS-1$
	public static final long SLEEP_TIME_AFTER_LAUNCHE = 60000;

	private IAcceptor acceptor;
	private IRepository repository;
	private Thread thread;

	public Object start(final IApplicationContext context) throws Exception {
		start(AbstractCDOServer.DB_NAME_PREFIX + System.currentTimeMillis(),
				AbstractCDOServer.PORT);
		while (true) {
			Thread.sleep(Long.MAX_VALUE);
		}
	}

	public void start(final String dbName, final int port) throws Exception {
		this.thread = new Thread() {
			@Override
			public void run() {
				try {
					// OMPlatform.INSTANCE.addLogHandler(PrintLogHandler.CONSOLE);
					// OMPlatform.INSTANCE.addTraceHandler(PrintTraceHandler.CONSOLE);
					// OMPlatform.INSTANCE.setDebugging(true);
					DataSource dataSource = getDataSource(dbName);
					IMappingStrategy mappingStrategy = getMappingStrategy();
					// Map<String, String> properties = new HashMap<String,
					// String>();
					// mappingProps.put(MappingStrategy.PROP_MAPPING_PRECEDENCE,
					// "MODEL");
					// mappingProps.put(MappingStrategy.PROP_TO_ONE_REFERENCE_MAPPING,
					// "LIKE_ATTRIBUTES");
					// mappingProps.put(MappingStrategy.PROP_TO_MANY_REFERENCE_MAPPING,
					// "ONE_TABLE_PER_REFERENCE");
					IDBAdapter dbAdapter = getDBAdapter();
					if (dbAdapter == null) {
						Exception e = new Exception("dbAdapter is null"); //$NON-NLS-1$
						IStatus status = new Status(IStatus.ERROR,
								Activator.PLUGIN_ID, e.getMessage(), e);
						Activator.getDefault().getLog().log(status);
					}
					IDBConnectionProvider dbConnectionProvider = DBUtil
							.createConnectionProvider(dataSource);
					IStore store = CDODBUtil.createStore(mappingStrategy,
							dbAdapter, dbConnectionProvider);
					Map<String, String> props = getProps();
					AbstractCDOServer.this.setRepository(CDOServerUtil
							.createRepository(
									AbstractCDOServer.REPOSITORY_NAME, store,
									props));
					CDORevisionCache cache = getCache();
					CDOServerUtil.addRepository(IPluginContainer.INSTANCE,
							AbstractCDOServer.this.getRepository());
					if (cache != null) {
						IRevisionManager iRevisionManager = AbstractCDOServer.this
								.getRepository().getRevisionManager();
						iRevisionManager.setCache(cache);
					}
					CDOServerUtil.prepareContainer(IPluginContainer.INSTANCE);
					AbstractCDOServer.this
							.setAcceptor((IAcceptor) IPluginContainer.INSTANCE
									.getElement("org.eclipse.net4j.acceptors", //$NON-NLS-1$
											"tcp", "0.0.0.0:" + port)); //$NON-NLS-1$ //$NON-NLS-2$
					Activator.getDefault().getLog().log(
							new Status(IStatus.INFO, Activator.PLUGIN_ID,
									"acceptor=" //$NON-NLS-1$
											+ AbstractCDOServer.this
													.getAcceptor().toString()));
					try {
						while (true) {
							Thread.sleep(Long.MAX_VALUE);
						}
					} catch (java.lang.InterruptedException e) {
						IStatus status = new Status(IStatus.INFO,
								Activator.PLUGIN_ID,
								"Server thread has benn stoped"); //$NON-NLS-1$
						Activator.getDefault().getLog().log(status);
					}
				} catch (Exception e) {
					e.printStackTrace();
					IStatus status = new Status(IStatus.ERROR,
							Activator.PLUGIN_ID, e.getMessage(), e);
					Activator.getDefault().getLog().log(status);
				}
			}
		};
		this.thread.start();
	}

	public void stop() {
		Activator.getDefault().getLog().log(
				new Status(IStatus.INFO, Activator.PLUGIN_ID,
						"Stopping the CDO server.")); //$NON-NLS-1$
		this.thread.interrupt();
		LifecycleUtil.deactivate(this.getAcceptor());
		LifecycleUtil.deactivate(this.getRepository());
		Activator.getDefault().getLog().log(
				new Status(IStatus.INFO, Activator.PLUGIN_ID,
						"The CDO server is stopped.")); //$NON-NLS-1$
	}

	protected abstract Map<String, String> getProps();

	protected abstract IMappingStrategy getMappingStrategy();

	protected abstract DataSource getDataSource(final String dbName)
			throws CoreException;

	protected abstract IDBAdapter getDBAdapter();

	protected CDORevisionCache getCache() {
		return null;
		// CDORevisionCache revisionCache = CDORevisionCacheUtil.createLRUCache(
		// CURRENT_LRU_CAPACITY, REVISED_LRU_CAPACITY);
		// return revisionCache;
	}

	public void setRepository(final IRepository repository) {
		this.repository = repository;
	}

	public IRepository getRepository() {
		return this.repository;
	}

	public void setAcceptor(final IAcceptor acceptor) {
		this.acceptor = acceptor;
	}

	public IAcceptor getAcceptor() {
		return this.acceptor;
	}

}
