/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.ui.controls;

import java.util.TreeSet;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Messages;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class MetamodelSelectionControl
extends Composite {
    private final Text filterText;
    private final FilteredList fFilteredList;

    public MetamodelSelectionControl(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        this.filterText = this.createFilterText(this);
        this.fFilteredList = this.createFilteredList(this);
        TreeSet<String> uris = new TreeSet<String>();
        for (Object name : EPackage.Registry.INSTANCE.keySet()) {
            uris.add(name.toString());
        }
        this.fFilteredList.setElements(uris.toArray());
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MetamodelSelectionControl.this.fFilteredList.setFilter("*" + MetamodelSelectionControl.this.filterText.getText());
            }
        });
        this.filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    MetamodelSelectionControl.this.fFilteredList.setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList filteredList = new FilteredList(parent, 2820, (ILabelProvider)new LabelProvider(), true, false, true);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        filteredList.setLayoutData((Object)data);
        filteredList.setFilter("");
        return filteredList;
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setMessage(Messages.MetamodelSelectionControl_typeFilterText);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        return text;
    }

    public String getSelectedMetamodel() {
        Object[] selection = this.fFilteredList.getSelection();
        if (selection.length > 0) {
            return (String)selection[0];
        }
        return null;
    }

    public FilteredList getFilteredList() {
        return this.fFilteredList;
    }

    public Text getFilterText() {
        return this.filterText;
    }
}

