/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.role.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmt.modisco.common.core.builder.EcoreCatalog;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.core.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RoleSetCatalog
extends EcoreCatalog {
    private static final String REGISTRATION_EXTENSION_POINT_ID = "org.eclipse.gmt.modisco.infra.role.registration";
    private static RoleSetCatalog singleton = null;
    private HashMap<EPackage, RoleSet> ePackageToDefaultRoleSetMap;

    public static RoleSetCatalog getSingleton() {
        if (singleton == null) {
            EcoreCatalog.getSingleton();
            ModelQuerySetCatalog.getSingleton();
            singleton = new RoleSetCatalog();
        }
        return singleton;
    }

    public HashMap<EPackage, RoleSet> getEPackageToDefaultRoleSetMap() {
        if (this.ePackageToDefaultRoleSetMap == null) {
            this.ePackageToDefaultRoleSetMap = new HashMap();
        }
        return this.ePackageToDefaultRoleSetMap;
    }

    private RoleSetCatalog() {
    }

    protected String getRootObjectName(EObject rootObject) {
        return ((RoleSet)rootObject).getName();
    }

    protected String getRootObjectNsUri(EObject rootObject) {
        return ((RoleSet)rootObject).getNsURI();
    }

    protected Class<?> getRootClass() {
        return RoleSet.class;
    }

    public RoleSet getRoleSet(String name) {
        return (RoleSet)this.getRootObject(name);
    }

    public RoleSet getDefaultRoleSet(EPackage ePackage) {
        return this.getEPackageToDefaultRoleSetMap().get(ePackage);
    }

    protected String getRegistryExtensionPoint() {
        return REGISTRATION_EXTENSION_POINT_ID;
    }

    public Collection<RoleSet> getAllRoleSets() {
        ArrayList<RoleSet> result = new ArrayList<RoleSet>();
        for (EObject eObject : this.getAllRootObjects()) {
            if (!(eObject instanceof RoleSet)) continue;
            RoleSet roleSet = (RoleSet)eObject;
            result.add(roleSet);
        }
        return result;
    }

    protected String getMoDiscoSubProtocol() {
        return "role";
    }

    protected EObject openResource(URI uri, IResource file) {
        RoleSet roleSet;
        EAnnotation annotation;
        EObject result = super.openResource(uri, file);
        if (result instanceof RoleSet && (annotation = (roleSet = (RoleSet)result).getEAnnotation("default")) != null && annotation.getReferences().size() == 1 && annotation.getReferences().get(0) instanceof EPackage) {
            EPackage ePackage = (EPackage)annotation.getReferences().get(0);
            this.getEPackageToDefaultRoleSetMap().put(ePackage, roleSet);
        }
        return result;
    }

    protected Plugin getActivator() {
        return Activator.getDefault();
    }

    public static /* bridge */ /* synthetic */ EcoreCatalog getSingleton() {
        return RoleSetCatalog.getSingleton();
    }
}

