/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.TypeView;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.ui.LoadCustomizationsDialog;
import org.eclipse.gmt.modisco.infra.browser.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.core.RoleSetCatalog;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadCustomizationsAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public LoadCustomizationsAction(IBrowserActionBarContributor browserActionBarContributor) {
        this.setToolTipText(Messages.BrowserActionBarContributor_loadCustomization);
        this.setImageDescriptor(ImageProvider.getInstance().getAddUiCustomIconDescriptor());
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null) {
            List<MetamodelView> registeredCustomizations = browser.getBrowserConfiguration().getCustomizationEngine().getRegisteredCustomizations();
            LoadCustomizationsDialog loadCustomizationsDialog = new LoadCustomizationsDialog(browser.getSite().getShell(), registeredCustomizations);
            if (loadCustomizationsDialog.open() == 0) {
                try {
                    List<MetamodelView> selectedCustomizations = loadCustomizationsDialog.getSelectedCustomizations();
                    if (loadCustomizationsDialog.isLoadRequiredRolesSelected()) {
                        this.loadRolesForCustomizations(selectedCustomizations, browser);
                    }
                    browser.loadCustomizations(selectedCustomizations);
                }
                catch (Exception e) {
                    MoDiscoBrowserPlugin.logException(Messages.BrowserActionBarContributor_loadingCustomizationFailed, e);
                }
            }
        }
    }

    private void loadRolesForCustomizations(List<MetamodelView> customizations, EcoreBrowser browser) {
        HashSet<Role> referencedRoles = new HashSet<Role>();
        Collection roleSets = RoleSetCatalog.getSingleton().getAllRoleSets();
        for (MetamodelView customization : customizations) {
            String metamodelURI = customization.getMetamodelURI();
            RoleSet customizedRoleSet = null;
            if (metamodelURI != null) {
                for (RoleSet roleSet : roleSets) {
                    if (!metamodelURI.equals(roleSet.getNsURI())) continue;
                    customizedRoleSet = roleSet;
                    break;
                }
            }
            if (customizedRoleSet == null) continue;
            EList types = customization.getTypes();
            for (TypeView typeView : types) {
                String metaclassName = typeView.getMetaclassName();
                Role role = this.findRoleWithFullyQualifiedName(metaclassName, customizedRoleSet);
                if (role != null) {
                    referencedRoles.add(role);
                    continue;
                }
                MoDiscoBrowserPlugin.logWarning(NLS.bind((String)Messages.BrowserActionBarContributor_missingRequiredRole, (Object[])new Object[]{metaclassName, customizedRoleSet.getName(), customization.getName()}));
            }
            for (Role referencedRole : referencedRoles) {
                browser.getBrowserConfiguration().loadRole(referencedRole);
            }
        }
        browser.reloadModel();
    }

    private Role findRoleWithFullyQualifiedName(String metaclassName, RoleSet customizedRoleSet) {
        EList roles = customizedRoleSet.getRoles();
        for (Role role : roles) {
            String roleName = EMFUtil.getMetaclassQualifiedName((EClassifier)role);
            if (!metaclassName.equals(roleName)) continue;
            return role;
        }
        return null;
    }
}

