/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.editors.EcoreBrowser;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RolePackage;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.core.RoleSetCatalog;
import org.eclipse.gmt.modisco.infra.role.ui.views.RoleSetContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;

public class LoadRolesAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;
    private final LabelProvider labelProvider = new LabelProvider(){

        public String getText(Object element) {
            String label;
            if (element instanceof RoleSet) {
                RoleSet roleSet = (RoleSet)element;
                label = roleSet.getName();
            } else if (element instanceof Role) {
                Role role = (Role)element;
                label = role.getName();
            } else {
                label = element == null ? "null" : element.getClass().getName();
            }
            return label;
        }

        public Image getImage(Object element) {
            return ImageUtils.getImage((Object)element);
        }
    };

    public LoadRolesAction(IBrowserActionBarContributor browserActionBarContributor) {
        this.browserActionBarContributor = browserActionBarContributor;
        this.setToolTipText(Messages.BrowserActionBarContributor_loadRole);
        this.setImageDescriptor(ImageProvider.getInstance().getRoleIconDescriptor());
    }

    public void run() {
        EcoreBrowser browser = this.browserActionBarContributor.getBrowser();
        if (browser != null) {
            RoleSetContentProvider treeContentProvider = new RoleSetContentProvider(RolePackage.eINSTANCE.getRole());
            CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(null, (ILabelProvider)this.labelProvider, (ITreeContentProvider)treeContentProvider);
            dialog.setTitle(Messages.BrowserActionBarContributor_dialogTitle_LoadRoles);
            dialog.setMessage(Messages.BrowserActionBarContributor_chooseRoleToLoad);
            Collection roleSets = RoleSetCatalog.getSingleton().getAllRoleSets();
            dialog.setInput((Object)roleSets.toArray());
            dialog.setInitialElementSelections(new ArrayList<Role>(browser.getBrowserConfiguration().getLoadedRoles()));
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                browser.getBrowserConfiguration().cleanRoles();
                HashSet<Role> rolesToLoad = new HashSet<Role>();
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object resultElement = objectArray[n2];
                    if (resultElement instanceof Role) {
                        Role role = (Role)resultElement;
                        rolesToLoad.add(role);
                    } else if (resultElement instanceof RoleSet) {
                        RoleSet roleSet = (RoleSet)resultElement;
                        rolesToLoad.addAll((Collection<Role>)roleSet.getRoles());
                    } else {
                        throw new RuntimeException("Unexpected element type");
                    }
                    ++n2;
                }
                for (Role roleToLoad : rolesToLoad) {
                    browser.getBrowserConfiguration().loadRole(roleToLoad);
                }
                if (rolesToLoad.size() > 0) {
                    browser.getBrowserConfiguration().getCustomizationEngine().loadCustomizations();
                }
                browser.reloadModel();
            }
        }
    }
}

