/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.role.RoleStructuralFeature;
import org.eclipse.gmt.modisco.infra.role.Shortcut;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PropertySourceAdapter
extends AdapterImpl
implements IPropertySource {
    private final BrowserConfiguration fBrowserConfiguration;

    public PropertySourceAdapter(Notifier target, BrowserConfiguration browserConfiguration) {
        this.fBrowserConfiguration = browserConfiguration;
        this.setTarget(target);
    }

    public boolean isAdapterForType(Object type) {
        return type == IPropertySource.class;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> propertyDescriptors = new ArrayList<PropertyDescriptor>();
        EObject eObject = (EObject)this.getTarget();
        ArrayList eAllAttributes = new ArrayList(eObject.eClass().getEAllAttributes());
        for (EAttribute eAttribute : eAllAttributes) {
            String name = eAttribute.isDerived() ? "/" + eAttribute.getName() : eAttribute.getName();
            propertyDescriptors.add(new PropertyDescriptor((Object)eAttribute, name));
        }
        List roleFeatures = this.fBrowserConfiguration.getRoleContext().getRoleFeatures(eObject);
        for (EStructuralFeature feature : roleFeatures) {
            if (!(feature instanceof EAttribute)) continue;
            EAttribute roleAttribute = (EAttribute)feature;
            propertyDescriptors.add(new PropertyDescriptor((Object)roleAttribute, "/" + roleAttribute.getName()));
        }
        return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
    }

    public Object getPropertyValue(Object id) {
        if (id instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)id;
            Object value = this.localEGet((EStructuralFeature)eAttribute);
            if (!eAttribute.isMany()) {
                if (value != null) {
                    return value.toString();
                }
                return "";
            }
            StringBuilder builder = new StringBuilder();
            List list = (List)value;
            int i = 0;
            while (i < list.size()) {
                Object object = list.get(i);
                builder.append(object.toString());
                if (i != list.size() - 1) {
                    builder.append(", ");
                }
                ++i;
            }
            return builder.toString();
        }
        return null;
    }

    private Object localEGet(EStructuralFeature structuralFeature) {
        Object result;
        EObject eObject = (EObject)this.getTarget();
        if (structuralFeature instanceof RoleStructuralFeature || structuralFeature instanceof Shortcut) {
            try {
                result = this.fBrowserConfiguration.getRoleContext().get(eObject, structuralFeature);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                result = null;
            }
        } else {
            result = eObject.eGet(structuralFeature);
        }
        return result;
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }
}

