/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.core.OperationCanceledException;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.browser.util.Util;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigListItem
implements ITreeElement {
    private static final int SPLIT_THRESHOLD = 1000;
    private static final int SHOW_PROGRESS_DIALOG_THRESHOLD = 5000;
    private final List<ModelElementItem> elements;
    private final ITreeElement treeParent;
    private final EObject modelParent;
    private final int startIndex;
    private final int endIndex;

    public BigListItem(List<ModelElementItem> elements, int startIndex, int endIndex, ITreeElement treeParent, EObject modelParent) {
        this.elements = elements;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.treeParent = treeParent;
        this.modelParent = modelParent;
    }

    public List<ModelElementItem> getChildren() {
        return this.elements;
    }

    public Object getParent() {
        return this.treeParent;
    }

    public EObject getModelParent() {
        return this.modelParent;
    }

    @Override
    public Image getImage() {
        return ImageProvider.getInstance().getRangeIcon();
    }

    @Override
    public String getText() {
        int nElements = this.elements.size();
        int maxDigits = (int)Math.ceil(Math.log10(nElements));
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        String strStartIndex = "" + this.startIndex;
        String strEndIndex = "" + (this.endIndex - 1);
        this.zeroes(maxDigits - strStartIndex.length(), buffer);
        buffer.append(strStartIndex);
        buffer.append("..");
        this.zeroes(maxDigits - strEndIndex.length(), buffer);
        buffer.append(strEndIndex);
        buffer.append("]");
        return buffer.toString();
    }

    private void zeroes(int count, StringBuilder buffer) {
        int i = 0;
        while (i < count) {
            buffer.append('0');
            ++i;
        }
    }

    public static List<?> splitElements(ITreeElement treeParent, EObject modelParent, List<EObject> elements, BrowserConfiguration browserConfiguration, boolean ordered) {
        if (elements.size() <= 1000) {
            ArrayList<ModelElementItem> modelElementItems = new ArrayList<ModelElementItem>();
            int order = 0;
            for (EObject element : elements) {
                ModelElementItem modelElementItem = new ModelElementItem(element, treeParent, browserConfiguration);
                if (ordered) {
                    modelElementItem.setOrder(order++);
                }
                modelElementItems.add(modelElementItem);
            }
            if (browserConfiguration.isSortInstances()) {
                BigListItem.sortElements(modelElementItems);
            }
            return modelElementItems;
        }
        ArrayList<ModelElementItem> modelElementItems = new ArrayList<ModelElementItem>();
        int order = 0;
        for (EObject element : elements) {
            ModelElementItem modelElementItem = new ModelElementItem(element, null, browserConfiguration);
            if (ordered) {
                modelElementItem.setOrder(order++);
            }
            modelElementItems.add(modelElementItem);
        }
        if (browserConfiguration.isSortInstances()) {
            BigListItem.sortElements(modelElementItems);
        }
        ArrayList<BigListItem> subLists = new ArrayList<BigListItem>();
        int start = 0;
        while (start < elements.size()) {
            int end = start + 1000;
            if (end > elements.size()) {
                end = elements.size();
            }
            List<ModelElementItem> sublist = modelElementItems.subList(start, end - 1);
            BigListItem bigListItem = new BigListItem(sublist, start, end, treeParent, modelParent);
            for (ModelElementItem sublistElement : sublist) {
                sublistElement.setTreeParent(bigListItem);
            }
            subLists.add(bigListItem);
            start += 1000;
        }
        return subLists;
    }

    private static void sortElements(final List<ModelElementItem> modelElementItems) {
        IRunnableWithProgress sortOperation = new IRunnableWithProgress(){

            public void run(final IProgressMonitor monitor) {
                monitor.beginTask(Messages.BigListItem_sortingInstances, -1);
                Collections.sort(modelElementItems, new Comparator<ModelElementItem>(){
                    private int count = 0;
                    private static final int CANCELED_POLLING_INTERVAL = 1000;

                    @Override
                    public int compare(ModelElementItem e1, ModelElementItem e2) {
                        int metaclassComparison;
                        if (this.count++ % 1000 == 0) {
                            if (monitor.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            Display.getDefault().readAndDispatch();
                        }
                        if ((metaclassComparison = e1.getEObject().eClass().getName().compareToIgnoreCase(e2.getEObject().eClass().getName())) != 0) {
                            return metaclassComparison;
                        }
                        String label1 = e1.getName();
                        String label2 = e2.getName();
                        return label1.compareToIgnoreCase(label2);
                    }
                });
            }
        };
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Shell shell = window != null ? window.getShell() : null;
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.setOpenOnRun(modelElementItems.size() > 5000);
            progressMonitorDialog.run(false, true, sortOperation);
        }
        catch (InvocationTargetException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
        catch (InterruptedException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
        catch (OperationCanceledException e) {
            MoDiscoBrowserPlugin.logInfo(Messages.BigListItem_sortingCanceled, e);
        }
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    @Override
    public boolean hasChildren() {
        return this.elements.size() > 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BigListItem) {
            BigListItem other = (BigListItem)obj;
            return Util.safeEquals(this.modelParent, other.modelParent) && this.startIndex == other.startIndex;
        }
        return false;
    }

    public int hashCode() {
        int ownHashCode = this.startIndex * 7 + 13;
        if (this.modelParent != null) {
            return this.modelParent.hashCode() * 47 + ownHashCode;
        }
        return ownHashCode;
    }
}

