/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.common.core.utils.StringUtils;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.AttributeItem;
import org.eclipse.gmt.modisco.infra.browser.core.ContainerLink;
import org.eclipse.gmt.modisco.infra.browser.core.ITreeElement;
import org.eclipse.gmt.modisco.infra.browser.core.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.core.QueryItem;
import org.eclipse.gmt.modisco.infra.browser.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.extensions.icons.IconProvidersRegistry;
import org.eclipse.gmt.modisco.infra.browser.extensions.naming.NameProvidersRegistry;
import org.eclipse.gmt.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.gmt.modisco.infra.browser.queries.SelectedQuery;
import org.eclipse.gmt.modisco.infra.browser.util.ColorProvider;
import org.eclipse.gmt.modisco.infra.browser.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RoleStructuralFeature;
import org.eclipse.gmt.modisco.infra.role.Shortcut;
import org.eclipse.gmt.modisco.infra.role.core.RoleContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementItem
implements ITreeElement {
    private final BrowserConfiguration browserConfiguration;
    private final EObject fModelElement;
    private ITreeElement treeParent;
    private int order = -1;
    private final HashMap<EReference, LinkItem> linkItems = new HashMap();
    private final HashMap<EAttribute, AttributeItem> attributeItems = new HashMap();
    private ContainerLink containmentLinkItem = null;
    private EObject oldContainer = null;
    private final RoleContext roleContext;

    public ModelElementItem(EObject eObject, ITreeElement treeParent, BrowserConfiguration browserConfiguration) {
        if (eObject == null) {
            throw new IllegalArgumentException("eObject is null");
        }
        this.fModelElement = eObject;
        this.treeParent = treeParent;
        this.browserConfiguration = browserConfiguration;
        this.roleContext = browserConfiguration.getRoleContext();
    }

    public List<Object> getChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.browserConfiguration.isShowContainer()) {
            this.addContainer(this.fModelElement, children);
        }
        this.addSelectedQueries(children);
        if (this.browserConfiguration.isShowAttributes()) {
            List<AttributeItem> attributes = this.createAttributes();
            if (this.browserConfiguration.isSortLinks()) {
                this.sortAttributes(attributes);
            }
            children.addAll(attributes);
        }
        ArrayList<LinkItem> links = this.createLinks();
        if (this.browserConfiguration.isSortLinks()) {
            this.sortLinks(links);
        }
        if (this.browserConfiguration.isSortLinksByType()) {
            this.sortLinksByType(links);
        }
        children.addAll(links);
        return children;
    }

    private List<AttributeItem> createAttributes() {
        ArrayList<AttributeItem> attributes = new ArrayList<AttributeItem>();
        EClass eClass = this.fModelElement.eClass();
        BasicEList allAttributes = new BasicEList();
        allAttributes.addAll((Collection)eClass.getEAllAttributes());
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        try {
            EList allAttributes2 = this.roleContext.getAttributes(this.fModelElement);
            allAttributes.addAll((Collection)allAttributes2);
        }
        catch (ModelQueryException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
        for (EAttribute attribute : allAttributes) {
            if (!customizationEngine.isAttributeVisible(eClass, attribute.getName(), this.fModelElement)) continue;
            boolean empty = false;
            if (!this.browserConfiguration.isShowEmptyAttributes()) {
                Object value = this.localEGet((EStructuralFeature)attribute);
                if (attribute.isMany()) {
                    empty = ((List)value).size() == 0;
                } else {
                    boolean bl = empty = value == null;
                }
            }
            if (!this.browserConfiguration.isShowEmptyAttributes() && empty) continue;
            AttributeItem attributeItem = this.attributeItems.get(attribute);
            if (attributeItem == null) {
                attributeItem = new AttributeItem(this.fModelElement, this, attribute, this.browserConfiguration);
                this.attributeItems.put(attribute, attributeItem);
            }
            attributes.add(attributeItem);
        }
        return attributes;
    }

    private ArrayList<LinkItem> createLinks() {
        ArrayList<LinkItem> links = new ArrayList<LinkItem>();
        EClass eClass = this.fModelElement.eClass();
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        ArrayList allReferences = new ArrayList();
        allReferences.addAll(eClass.getEAllReferences());
        try {
            allReferences.addAll(this.roleContext.getReferences(this.fModelElement));
        }
        catch (ModelQueryException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
        for (EReference reference : allReferences) {
            EList refList;
            if (!customizationEngine.isReferenceVisible(eClass, reference.getName(), this.fModelElement) || reference.isDerived() && !this.browserConfiguration.isShowDerivedLinks()) continue;
            Object ref = this.localEGet((EStructuralFeature)reference);
            if (!this.browserConfiguration.isShowEmptyLinks() && (ref == null || ref instanceof EList && (refList = (EList)ref).size() == 0)) continue;
            LinkItem linkItem = this.linkItems.get(reference);
            if (linkItem == null) {
                linkItem = new LinkItem(this.fModelElement, this, reference, this.browserConfiguration);
                this.linkItems.put(reference, linkItem);
            }
            links.add(linkItem);
        }
        return links;
    }

    private void addContainer(EObject eObject, ArrayList<Object> children) {
        if (eObject.eContainer() != null) {
            if (this.containmentLinkItem == null || this.oldContainer != eObject.eContainer()) {
                this.containmentLinkItem = new ContainerLink(eObject, this, eObject.eContainer(), this.browserConfiguration);
                this.oldContainer = eObject.eContainer();
            }
            children.add(this.containmentLinkItem);
        } else if (this.browserConfiguration.isShowEmptyLinks()) {
            this.containmentLinkItem = new ContainerLink(eObject, this, null, this.browserConfiguration);
            this.oldContainer = null;
            children.add(this.containmentLinkItem);
        }
    }

    private void addSelectedQueries(List<Object> children) {
        SelectedQueriesManager selectedQueriesManager = this.browserConfiguration.getSelectedQueriesManager();
        List<SelectedQuery> selectedQueries = selectedQueriesManager.getSelectedQueriesFor(this.fModelElement);
        if (selectedQueries != null && selectedQueries.size() > 0) {
            for (SelectedQuery selectedQuery : selectedQueries) {
                if (selectedQuery.getModelQuery() != null) {
                    children.add(new QueryItem(this.fModelElement, this, selectedQuery, this.browserConfiguration));
                    continue;
                }
                MoDiscoBrowserPlugin.logError(Messages.ModelElementItem_nullQuerySelected);
            }
        }
    }

    private void sortLinks(List<LinkItem> links) {
        Collections.sort(links, new Comparator<LinkItem>(){

            @Override
            public int compare(LinkItem o1, LinkItem o2) {
                String name1 = o1.getReference().getName();
                String name2 = o2.getReference().getName();
                return name1.compareTo(name2);
            }
        });
    }

    private void sortLinksByType(List<LinkItem> links) {
        Collections.sort(links, new Comparator<LinkItem>(){

            @Override
            public int compare(LinkItem o1, LinkItem o2) {
                int r1 = ModelElementItem.getReferenceRank(o1.getReference());
                int r2 = ModelElementItem.getReferenceRank(o2.getReference());
                return r1 - r2;
            }
        });
    }

    public static int getReferenceRank(EReference reference) {
        EReference opposite = reference.getEOpposite();
        int rank = reference.isContainment() ? (opposite != null ? 0 : 10) : (opposite != null ? (opposite.isContainment() ? 20 : 30) : 40);
        if (reference.isDerived()) {
            ++rank;
        }
        return rank;
    }

    private void sortAttributes(List<AttributeItem> attributes) {
        Collections.sort(attributes, new Comparator<AttributeItem>(){

            @Override
            public int compare(AttributeItem o1, AttributeItem o2) {
                String name1 = o1.getAttribute().getName();
                String name2 = o2.getAttribute().getName();
                return name1.compareTo(name2);
            }
        });
    }

    @Override
    public String getText() {
        EClass eClass = this.fModelElement.eClass();
        String label = this.browserConfiguration.isShowFullQualifiedNames() ? EMFUtil.getMetaclassQualifiedName((EClassifier)eClass) : eClass.getName();
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        boolean hideMetaclassName = customizationEngine.isHideMetaclassName(eClass, this.fModelElement);
        String ordering = this.browserConfiguration.isShowOrdering() && this.order != -1 ? " [" + this.order + "]" : "";
        if (hideMetaclassName) {
            return String.valueOf(this.getName()) + ordering;
        }
        return "[" + label + "] " + this.getName() + ordering;
    }

    public String getName() {
        return ModelElementItem.getDisplayName(this.fModelElement, this.browserConfiguration);
    }

    public static String getDisplayName(EObject eObject, BrowserConfiguration browserConfiguration) {
        CustomizationEngine customizationEngine = browserConfiguration.getCustomizationEngine();
        String customizedLabel = customizationEngine.getTypeLabel(eObject);
        if (customizedLabel != null) {
            return customizedLabel;
        }
        String providedName = ModelElementItem.getProvidedName(eObject);
        if (providedName != null) {
            return providedName;
        }
        String nameFromRegistry = ModelElementItem.getNameFromAdapter(eObject, (AdapterFactory)browserConfiguration.getAdapterFactoryWithRegistry());
        if (nameFromRegistry != null) {
            return nameFromRegistry;
        }
        return ModelUtils.getDefaultName((EObject)eObject);
    }

    public static String getNameFromAdapter(EObject eObject, AdapterFactory adapter) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapter.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText((Object)eObject);
        }
        return null;
    }

    public static String getProvidedName(EObject eObject) {
        NameProvidersRegistry nameProvidersRegistry = NameProvidersRegistry.getInstance();
        String name = nameProvidersRegistry.getName(eObject);
        if (name != null) {
            return StringUtils.truncateBeforeNewline((String)name);
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Color getForeground() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getTypeColor(this.fModelElement);
        if (color != null) {
            return color;
        }
        if (this.fModelElement.eResource() == null) {
            return ColorProvider.getInstance().getNullResourceColor();
        }
        if (!EMFUtil.isInFirstResource(this.fModelElement)) {
            return ColorProvider.getInstance().getExternalResourceColor();
        }
        return null;
    }

    @Override
    public Color getBackground() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Color color = customizationEngine.getTypeBackgroundColor(this.fModelElement);
        if (color != null) {
            return color;
        }
        return null;
    }

    @Override
    public Font getFont() {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        Font customizedFont = customizationEngine.getCustomizedTypeFont(this.fModelElement, this.browserConfiguration.getCustomFont());
        if (customizedFont != null) {
            return customizedFont;
        }
        return null;
    }

    @Override
    public Image getImage() {
        Image image = ModelElementItem.getImageFor(this.fModelElement, this.browserConfiguration);
        if (image != null) {
            return image;
        }
        String className = this.fModelElement.eClass().getName();
        URI imageURI = URI.createURI((String)(String.valueOf(EMFEditPlugin.INSTANCE.getImage("full/obj16/Item").toString()) + "#" + className));
        return ExtendedImageRegistry.getInstance().getImage((Object)imageURI);
    }

    public static Image getImageFor(EObject eObject, BrowserConfiguration browserConfiguration) {
        try {
            CustomizationEngine customizationEngine = browserConfiguration.getCustomizationEngine();
            try {
                for (Role role : browserConfiguration.getRoleContext().getRoles(eObject)) {
                    Image customizedIcon = customizationEngine.getRoleMainIcon(eObject, (EClass)role);
                    if (customizedIcon == null) continue;
                    return customizedIcon;
                }
            }
            catch (ModelQueryException e) {
                MoDiscoBrowserPlugin.logException(e);
            }
            Image customizedIcon = customizationEngine.getTypeIcon(eObject, eObject.eClass());
            if (customizedIcon != null) {
                return customizedIcon;
            }
            IconProvidersRegistry iconProvidersRegistry = IconProvidersRegistry.getInstance();
            Image icon = iconProvidersRegistry.getIcon(eObject);
            if (icon != null) {
                return icon;
            }
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)browserConfiguration.getAdapterFactoryWithRegistry().adapt((Notifier)eObject, IItemLabelProvider.class);
            if (itemLabelProvider != null) {
                Object image = itemLabelProvider.getImage((Object)eObject);
                return ExtendedImageRegistry.getInstance().getImage(image);
            }
        }
        catch (Exception e) {
            MoDiscoBrowserPlugin.logException("Error retrieving image", e);
        }
        return null;
    }

    @Override
    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    public void setTreeParent(ITreeElement treeParent) {
        this.treeParent = treeParent;
    }

    public EObject getEObject() {
        return this.fModelElement;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelElementItem) {
            ModelElementItem other = (ModelElementItem)obj;
            return this.fModelElement.equals(other.fModelElement);
        }
        return false;
    }

    public int hashCode() {
        return this.fModelElement.hashCode();
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private Object localEGet(EStructuralFeature structuralFeature) {
        Object result;
        if (structuralFeature instanceof RoleStructuralFeature || structuralFeature instanceof Shortcut) {
            try {
                result = this.roleContext.get(this.fModelElement, structuralFeature);
            }
            catch (Exception e) {
                MoDiscoBrowserPlugin.logException(e);
                result = null;
            }
        } else {
            result = this.fModelElement.eGet(structuralFeature);
        }
        return result;
    }
}

