/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.editors;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.AttributeItem;
import org.eclipse.gmt.modisco.infra.browser.core.LinkItem;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.browser.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.customization.OverlayIconImageInfo;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomTreePainter {
    private static final int MAX_ALPHA = 255;
    private final BrowserConfiguration browserConfiguration;
    private final Tree fTree;
    private int mouseX;
    private int mouseY;
    private boolean hovering = false;
    public static final int ROLE_ICON_SIZE = 16;
    public static final int MARGIN = 8;
    public static final int SPACING = 5;

    public CustomTreePainter(final Tree tree, BrowserConfiguration browserConfiguration) {
        this.fTree = tree;
        this.browserConfiguration = browserConfiguration;
        this.setupTreeCustomPaint(tree);
        tree.getHorizontalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tree.redraw();
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                CustomTreePainter.this.mouseX = e.x;
                CustomTreePainter.this.mouseY = e.y;
                if (CustomTreePainter.this.hovering) {
                    CustomTreePainter.this.hovering = false;
                    tree.redraw();
                }
            }
        });
        tree.addListener(7, new Listener(){

            public void handleEvent(Event event) {
                if (CustomTreePainter.this.hovering) {
                    CustomTreePainter.this.mouseX = 0;
                    CustomTreePainter.this.mouseY = 0;
                    CustomTreePainter.this.hovering = false;
                    tree.redraw();
                }
            }
        });
        tree.addListener(32, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.hovering = true;
                tree.redraw();
            }
        });
    }

    private boolean isOrderedReference(Object object) {
        if (this.browserConfiguration.isSortInstances()) {
            return false;
        }
        if (object instanceof LinkItem) {
            LinkItem linkItemProvider = (LinkItem)object;
            EReference reference = linkItemProvider.getReference();
            return reference.isMany() && reference.isOrdered();
        }
        return false;
    }

    private boolean isOrderingEnabled() {
        return this.browserConfiguration.isShowOrdering();
    }

    private void handleMeasureItem(Event event) {
        int maxX;
        ModelElementItem modelElementItem;
        EObject eObject;
        List<RoleToPaint> rolesToPaint;
        TreeItem item = (TreeItem)event.item;
        Object data = item.getData();
        if (this.isOrderingEnabled() && this.isOrderedReference(data)) {
            event.width += 5 + event.height / 2 + 1;
        }
        if (data instanceof ModelElementItem && !(rolesToPaint = this.getRolesToPaintFor(eObject = (modelElementItem = (ModelElementItem)data).getEObject(), event.x, event.width, event.y, event.height, maxX = this.fTree.getClientArea().width + this.fTree.getHorizontalBar().getSelection())).isEmpty()) {
            Rectangle lastRoleBounds = rolesToPaint.get(rolesToPaint.size() - 1).getBounds();
            event.width = lastRoleBounds.x + lastRoleBounds.width;
        }
    }

    private void handlePaintItem(Event event) {
        TreeItem item = (TreeItem)event.item;
        Object data = item.getData();
        if (this.isOrderingEnabled() && this.isOrderedReference(data)) {
            this.paintOrderArrow(event);
        }
        this.paintCustomization(data, event);
        this.paintRoleIcons(data, event);
    }

    public List<RoleToPaint> getRolesToPaintFor(EObject eObject, int posX, int width, int posY, int height, int maxX) {
        int rightX = posX + width;
        int offset = 8;
        ArrayList<RoleToPaint> rolesToPaint = new ArrayList<RoleToPaint>();
        int lastX = 0;
        try {
            CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
            Rectangle itemBounds = new Rectangle(posX, posY, width, height);
            for (Role role : this.browserConfiguration.getRoleContext().getRoles(eObject)) {
                Image customizedIcon;
                OverlayIconImageInfo roleOverlayIcon = customizationEngine.getRoleOverlayIcon(eObject, (EClass)role);
                if (roleOverlayIcon != null) {
                    Point overlayIconOffset = this.getOverlayIconOffset(roleOverlayIcon);
                    Rectangle targetBounds = new Rectangle(posX + overlayIconOffset.x, posY + overlayIconOffset.y, 8, 8);
                    rolesToPaint.add(new RoleToPaint(targetBounds, itemBounds, role, roleOverlayIcon.getImage(), true));
                    continue;
                }
                Image mainIcon = customizationEngine.getRoleMainIcon(eObject, (EClass)role);
                if (mainIcon != null || (customizedIcon = customizationEngine.getTypeIcon(eObject, (EClass)role)) == null) continue;
                Rectangle targetBounds = new Rectangle(rightX + offset, posY, 16, 16);
                offset += 21;
                rolesToPaint.add(new RoleToPaint(targetBounds, itemBounds, role, customizedIcon, false));
                lastX = targetBounds.x + targetBounds.width;
            }
        }
        catch (ModelQueryException e) {
            MoDiscoBrowserPlugin.logException(Messages.CustomTreePainter_errorDrawingRoleIcon, e);
        }
        if (lastX > maxX) {
            int shift = lastX - maxX;
            ListIterator rolesToPaintIterator = rolesToPaint.listIterator();
            while (rolesToPaintIterator.hasNext()) {
                RoleToPaint roleToPaint = (RoleToPaint)rolesToPaintIterator.next();
                if (roleToPaint.isOverlay()) continue;
                roleToPaint.getBounds().x -= shift;
                if (roleToPaint.getBounds().x < posX + 50) {
                    rolesToPaintIterator.remove();
                    continue;
                }
                int overlapWithText = rightX - roleToPaint.getBounds().x;
                if (overlapWithText <= 0) continue;
                int alpha = Math.max(255 - overlapWithText * 3, 128);
                roleToPaint.setAlpha(alpha);
            }
        }
        return rolesToPaint;
    }

    private Point getOverlayIconOffset(OverlayIconImageInfo roleOverlayIcon) {
        switch (roleOverlayIcon.getIconPosition()) {
            case TopLeft: {
                return new Point(0, 0);
            }
            case TopMiddle: {
                return new Point(8, 0);
            }
            case TopRight: {
                return new Point(16, 0);
            }
            case BottomLeft: {
                return new Point(0, 8);
            }
            case BottomMiddle: {
                return new Point(8, 8);
            }
            case BottomRight: {
                return new Point(16, 8);
            }
        }
        MoDiscoLogger.logError((String)"Unhandled overlay icon position", (Plugin)MoDiscoBrowserPlugin.getPlugin());
        return null;
    }

    private void paintRoleIcons(Object data, Event event) {
        if (data instanceof ModelElementItem) {
            int maxX;
            ModelElementItem modelElementItem = (ModelElementItem)data;
            EObject eObject = modelElementItem.getEObject();
            List<RoleToPaint> rolesToPaint = this.getRolesToPaintFor(eObject, event.x, event.width, event.y, event.height, maxX = this.fTree.getClientArea().width + this.fTree.getHorizontalBar().getSelection());
            if (rolesToPaint.isEmpty()) {
                this.fTree.setToolTipText(null);
                return;
            }
            this.fTree.setToolTipText("");
            boolean showStickers = !this.hovering || !this.hoveringOnTextLeftOfRoles(rolesToPaint);
            for (RoleToPaint roleToPaint : rolesToPaint) {
                Image customizedIcon = roleToPaint.getImage();
                if (customizedIcon == null) continue;
                Rectangle bounds = customizedIcon.getBounds();
                Rectangle target = roleToPaint.getBounds();
                if (!roleToPaint.isOverlay()) {
                    if (!showStickers) continue;
                    boolean hoveringOverRole = this.hovering && roleToPaint.getBounds().contains(this.mouseX, this.mouseY);
                    int alpha = roleToPaint.getAlpha();
                    if (hoveringOverRole) {
                        alpha = 255;
                    }
                    event.gc.setAlpha(alpha);
                }
                event.gc.drawImage(customizedIcon, 0, 0, bounds.width, bounds.height, target.x, target.y, target.width, target.height);
            }
        }
    }

    private boolean hoveringOnTextLeftOfRoles(List<RoleToPaint> rolesToPaint) {
        if (rolesToPaint.size() == 0) {
            return false;
        }
        if (rolesToPaint.get(0).getAlpha() == 255) {
            return false;
        }
        RoleToPaint first = rolesToPaint.get(0);
        return first.getItemBounds().contains(this.mouseX, this.mouseY) && this.mouseX < first.getBounds().x;
    }

    private void paintCustomization(Object element, Event event) {
        CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
        boolean underlined = false;
        boolean struckthrough = false;
        if (element instanceof ModelElementItem) {
            ModelElementItem elementItem = (ModelElementItem)element;
            EObject eObject = elementItem.getEObject();
            underlined = customizationEngine.isTypeUnderlined(eObject.eClass(), eObject);
            struckthrough = customizationEngine.isTypeStruckthrough(eObject.eClass(), eObject);
        } else if (element instanceof AttributeItem) {
            AttributeItem attributeItem = (AttributeItem)element;
            EObject parent = attributeItem.getParent();
            underlined = customizationEngine.isAttributeUnderlined(attributeItem.roleOrParentClass(), attributeItem.getAttribute().getName(), parent);
            struckthrough = customizationEngine.isAttributeStruckthrough(attributeItem.roleOrParentClass(), attributeItem.getAttribute().getName(), parent);
        } else if (element instanceof LinkItem) {
            LinkItem linkItem = (LinkItem)element;
            EObject parent = linkItem.getParent();
            underlined = customizationEngine.isReferenceUnderlined(linkItem.roleOrParentClass(), linkItem.getReference().getName(), parent);
            struckthrough = customizationEngine.isReferenceStruckthrough(linkItem.roleOrParentClass(), linkItem.getReference().getName(), parent);
        }
        if (underlined) {
            int y = event.y + event.height - 2;
            event.gc.drawLine(event.x + 20, y, event.x + event.width - 5, y);
        }
        if (struckthrough) {
            int y = event.y + event.height / 2 + 1;
            event.gc.drawLine(event.x + 20, y, event.x + event.width - 5, y);
        }
    }

    private void paintOrderArrow(Event event) {
        int left;
        int arrowSize = event.height / 2;
        arrowSize -= arrowSize % 4;
        int top = event.y + event.height / 4;
        int x0 = left = event.x + event.width + 5;
        int x1 = left + arrowSize / 4;
        int x2 = left + arrowSize / 2;
        int x3 = left + arrowSize / 4 * 3;
        int x4 = left + arrowSize;
        int y0 = top;
        int y1 = top + arrowSize / 2;
        int y2 = top + arrowSize;
        event.gc.drawPolygon(new int[]{x1, y0, x3, y0, x3, y1, x4, y1, x2, y2, x0, y1, x1, y1});
    }

    private void setupTreeCustomPaint(Tree tree) {
        tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.handleMeasureItem(event);
            }
        });
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                CustomTreePainter.this.handlePaintItem(event);
            }
        });
    }

    public void dispose() {
    }

    public class RoleToPaint {
        private static final int INITIAL_ALPHA = 255;
        private final Rectangle bounds;
        private final Role role;
        private int alpha = 255;
        private final Rectangle itemBounds;
        private final Image image;
        private final boolean overlay;

        public RoleToPaint(Rectangle bounds, Rectangle itemBounds, Role role, Image image, boolean overlay) {
            this.bounds = bounds;
            this.itemBounds = itemBounds;
            this.role = role;
            this.image = image;
            this.overlay = overlay;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public Rectangle getItemBounds() {
            return this.itemBounds;
        }

        public Role getRole() {
            return this.role;
        }

        public Image getImage() {
            return this.image;
        }

        public boolean isOverlay() {
            return this.overlay;
        }

        public void setAlpha(int alpha) {
            this.alpha = alpha;
        }

        public int getAlpha() {
            return this.alpha;
        }
    }
}

