/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.ui.MoDiscoWorkLaunchConfigurationDialog;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPage
extends WizardPage {
    private Composite rootContainer;
    private ControllerDriverPage controllerDriverpage;
    private Constants mode;
    private ScrolledComposite scrollContainer;
    protected Set<String> fReservedNames = null;
    private LaunchGroupExtension group;
    private MoDiscoWorkLaunchConfigurationDialog dialog;

    protected DriverPage(String pageName, Constants mode, LaunchGroupExtension group) {
        super(pageName);
        this.setImageDescriptor(Activator.getImageDescriptor("icon/bigModiscoWorkflow.png"));
        this.mode = mode;
        this.group = group;
    }

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        GridLayout layout = new GridLayout();
        this.rootContainer.setLayout((Layout)layout);
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.dialog = new MoDiscoWorkLaunchConfigurationDialog(this.getShell(), this.group, this.rootContainer, this);
        this.setControl((Control)this.scrollContainer);
        this.setControl((Control)this.rootContainer);
        this.rootContainer.layout();
        this.scrollContainer.setMinSize(this.rootContainer.computeSize(-1, -1));
        this.scrollContainer.layout();
        if (this.mode.equals((Object)Constants.editMode)) {
            this.controllerDriverpage.refreshDriverPage(this.controllerDriverpage.getTypeEdition());
            this.controllerDriverpage.getDriverPage().initializeFrom(this.controllerDriverpage.getConfigurationEdition());
            this.controllerDriverpage.getDriverPage().refresh();
        }
    }

    public void refresh() {
        Control[] controlArray = this.rootContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            this.setControl(ctrl);
            ++n2;
        }
        this.rootContainer.layout();
        this.setControl((Control)this.scrollContainer);
        this.setControl((Control)this.rootContainer);
        this.dialog.updateMessage();
    }

    public void setController(ControllerDriverPage controllerDriverpage) {
        controllerDriverpage.setDriverPage(this);
        this.controllerDriverpage = controllerDriverpage;
    }

    public String getTransformationName() {
        return this.dialog.getTabGroupViewer().getWorkingCopy().getName();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().setSize(800, 650);
            this.getShell().setLocation(Common.getInstance().centerShell(Display.getDefault(), this.getShell()));
        }
        super.setVisible(visible);
    }

    public void createTab(String typeLaunch) {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(typeLaunch);
        ILaunchConfigurationWorkingCopy launchConfiguration = null;
        try {
            launchConfiguration = type.newInstance(null, DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(Constants.configurationDefaultName));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.dialog.getTabGroupViewer().setInput(launchConfiguration);
    }

    public ILaunchConfigurationWorkingCopy performApply() {
        this.dialog.getTabGroupViewer().handleApplyPressed();
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            config = this.dialog.getTabGroupViewer().getWorkingCopy().getParent().doSave();
            wc = config.getWorkingCopy();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return wc;
    }

    public void initializeFrom(ILaunchConfigurationWorkingCopy configurationEdition) {
        this.dialog.getTabGroupViewer().setInput(configurationEdition);
    }

    public Set<String> getReservedNameSet() {
        return this.fReservedNames;
    }
}

