/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.common.ui.util.ImageProvider;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.ModelQuerySet;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySelectionDialog
extends Dialog {
    private final Collection<ModelQuerySet> fQuerySets;
    private final ViewerFilter viewerFilter;
    private FilteredTree filteredTree;
    private final boolean multiSelection;
    private List<ModelQuery> selectedQueries;

    public QuerySelectionDialog(Shell parentShell, boolean multiSelection, Collection<ModelQuerySet> querySets, ViewerFilter viewerFilter) {
        super(parentShell);
        this.multiSelection = multiSelection;
        this.fQuerySets = querySets == null ? ModelQuerySetCatalog.getSingleton().getAllModelQuerySets() : querySets;
        this.viewerFilter = viewerFilter;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.filteredTree = QuerySelectionDialog.createFilteredTree(composite, this.fQuerySets, this.viewerFilter, this.multiSelection);
        this.filteredTree.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                QuerySelectionDialog.this.okPressed();
            }
        });
        return composite;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.QuerySelectionDialog_selectQuery);
        shell.setImage(ImageProvider.getInstance().getModiscoLogo());
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(((Object)((Object)this)).getClass().getName()) + ".settings";
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    protected void okPressed() {
        this.selectedQueries = new ArrayList<ModelQuery>();
        ISelection selection = this.filteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof ModelQuery)) continue;
                this.selectedQueries.add((ModelQuery)selectedElement);
            }
        }
        super.okPressed();
    }

    public List<ModelQuery> getSelectedQueries() {
        return this.selectedQueries;
    }

    public static FilteredTree createFilteredTree(Composite parent, Collection<ModelQuerySet> availableQuerySets, ViewerFilter viewerFilter, boolean multiSelection) {
        Collection querySets = availableQuerySets == null ? ModelQuerySetCatalog.getSingleton().getAllModelQuerySets() : availableQuerySets;
        PatternFilter filter = new PatternFilter();
        int selectionStyle = multiSelection ? 2 : 4;
        FilteredTree tree = new FilteredTree(parent, selectionStyle | 0x100 | 0x200 | 0x800, filter, true);
        TreeViewer viewer = tree.getViewer();
        viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object inputElement) {
                List querySets = (List)inputElement;
                return querySets.toArray();
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)parentElement;
                    return querySet.getQueries().toArray();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof ModelQuery) {
                    ModelQuery query = (ModelQuery)element;
                    return query.getModelQuerySet();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)element;
                    return !querySet.getQueries().isEmpty();
                }
                return false;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ModelQuerySet) {
                    ModelQuerySet querySet = (ModelQuerySet)element;
                    return querySet.getName();
                }
                if (element instanceof ModelQuery) {
                    ModelQuery query = (ModelQuery)element;
                    return query.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        });
        if (viewerFilter != null) {
            viewer.setFilters(new ViewerFilter[]{viewerFilter});
        }
        viewer.setInput((Object)querySets);
        return tree;
    }
}

