/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.query.ModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.gmt.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryContext;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryResult;
import org.eclipse.gmt.modisco.infra.query.runtime.RuntimeFactory;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.gmt.modisco.infra.query.ui.dialogs.QuerySelectionDialog;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.ContextPaneMenuManager;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.DropAdapter;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.QueryResultDisplayersRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryExecutionView
extends ViewPart {
    private static final int EXECUTE_BUTTON_MIN_WIDTH = 100;
    public static final String ID = "org.eclipse.gmt.modisco.infra.query.ui.queryExecutionView";
    private TreeViewer contextViewer;
    private Composite mainComposite;
    private Composite parentComposite;
    private final Set<EObject> context = new HashSet<EObject>();
    private LayoutStyle layoutStyle = LayoutStyle.Horizontal;
    private FilteredTree querySelectionFilteredTree;
    private Combo comboResultDisplayer;

    public void createPartControl(final Composite parent) {
        this.parentComposite = parent;
        parent.setLayout((Layout)this.gridLayoutWithNoMargins());
        this.layoutStyle = LayoutStyle.Horizontal;
        this.createMainComposite();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LayoutStyle oldLayoutStyle = QueryExecutionView.this.layoutStyle;
                Point size = parent.getSize();
                if (size.x > size.y) {
                    QueryExecutionView.this.layoutStyle = LayoutStyle.Horizontal;
                } else {
                    QueryExecutionView.this.layoutStyle = LayoutStyle.Vertical;
                }
                if (QueryExecutionView.this.layoutStyle != oldLayoutStyle) {
                    QueryExecutionView.this.createMainComposite();
                }
            }
        });
    }

    private void createMainComposite() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)this.gridLayoutWithNoMargins());
        int direction = this.layoutStyle == LayoutStyle.Horizontal ? 256 : 512;
        SashForm sashForm = new SashForm(this.mainComposite, 0x10000 | direction);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createQueryGroup((Composite)sashForm);
        this.createContextGroup((Composite)sashForm);
        Composite lastGroup = new Composite((Composite)sashForm, 0);
        if (this.layoutStyle == LayoutStyle.Horizontal) {
            lastGroup.setLayout((Layout)new GridLayout(2, false));
        } else {
            lastGroup.setLayout((Layout)new GridLayout());
        }
        this.createParametersGroup(lastGroup);
        this.createExecuteGroup(lastGroup);
    }

    private GridLayout gridLayoutWithNoMargins() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private void createQueryGroup(Composite parent) {
        Group queryGroup = new Group(parent, 0);
        queryGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        queryGroup.setText("Query");
        GridLayout groupLayout = new GridLayout();
        queryGroup.setLayout((Layout)groupLayout);
        this.querySelectionFilteredTree = QuerySelectionDialog.createFilteredTree((Composite)queryGroup, null, null, false);
        GridData controlData = new GridData(4, 4, true, true);
        this.querySelectionFilteredTree.setLayoutData((Object)controlData);
        this.querySelectionFilteredTree.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                QueryExecutionView.this.executeClicked();
            }
        });
    }

    private void createContextGroup(Composite parent) {
        Group contextGroup = new Group(parent, 0);
        contextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        contextGroup.setText("Context");
        GridLayout groupLayout = new GridLayout();
        contextGroup.setLayout((Layout)groupLayout);
        this.createContextViewer(contextGroup);
    }

    private void createContextViewer(Group contextGroup) {
        this.contextViewer = new TreeViewer((Composite)contextGroup, 2050);
        GridData listData = new GridData(4, 4, true, true);
        this.contextViewer.getTree().setLayoutData((Object)listData);
        this.addDropSupport(this.contextViewer);
        this.createContextMenu(this.contextViewer);
        this.contextViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Set) {
                    Set set = (Set)inputElement;
                    if (!set.isEmpty()) {
                        return set.toArray();
                    }
                    return new Object[]{"drag&drop model elements here"};
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                return null;
            }
        });
        this.contextViewer.setLabelProvider((IBaseLabelProvider)new QueryContextLabelProvider());
        this.contextViewer.setInput(this.context);
        this.contextViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LabelProvider labelProvider = (LabelProvider)QueryExecutionView.this.contextViewer.getLabelProvider();
                String label1 = labelProvider.getText(e1);
                String label2 = labelProvider.getText(e2);
                return label1.compareToIgnoreCase(label2);
            }
        });
    }

    private void createContextMenu(TreeViewer treeViewer) {
        ContextPaneMenuManager menuManager = new ContextPaneMenuManager(this, this.context, treeViewer);
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
    }

    private void addDropSupport(TreeViewer viewer) {
        DropAdapter dropTargetListener = new DropAdapter(new DropAdapter.DropAction(){

            @Override
            public void dropped(Set<EObject> eObjects) {
                QueryExecutionView.this.context.addAll(eObjects);
                QueryExecutionView.this.refreshContextViewer();
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)dropTargetListener);
    }

    private void refreshContextViewer() {
        this.contextViewer.refresh();
    }

    private void createParametersGroup(Composite parent) {
        Group parametersGroup = new Group(parent, 0);
        parametersGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        parametersGroup.setText("Parameters");
        parametersGroup.setLayout((Layout)new GridLayout());
        new Label((Composite)parametersGroup, 0).setText("<Not implemented yet>");
    }

    private void createExecuteGroup(Composite parent) {
        Group executeGroup = new Group(parent, 0);
        executeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        executeGroup.setText("Execute");
        executeGroup.setLayout((Layout)new GridLayout());
        this.createDisplayStyleComposite(executeGroup);
        Button buttonExecute = new Button((Composite)executeGroup, 8);
        buttonExecute.setText("E&xecute");
        GridData buttonData = new GridData(0x1000000, 0, true, false);
        buttonData.minimumWidth = 100;
        buttonExecute.setLayoutData((Object)buttonData);
        buttonExecute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryExecutionView.this.executeClicked();
            }
        });
    }

    protected void executeClicked() {
        ModelQuerySetCatalog querySetCatalog = ModelQuerySetCatalog.getSingleton();
        ModelQuery selectedQuery = this.getSelectedQuery();
        if (selectedQuery != null) {
            try {
                AbstractModelQuery modelQueryImpl = querySetCatalog.getModelQueryImpl(selectedQuery);
                ModelQueryContext modelQueryContext = RuntimeFactory.eINSTANCE.createModelQueryContext();
                modelQueryContext.getSelectedModelElements().addAll(this.context);
                List result = modelQueryImpl.evaluate(modelQueryContext, Collections.emptyList());
                this.displayResult(result);
            }
            catch (ModelQueryException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)"No query", (String)"You must select a query to execute");
        }
    }

    private void displayResult(List<ModelQueryResult> result) {
        String displayerName = this.comboResultDisplayer.getText();
        QueryResultDisplayersRegistry.NamedQueryResultDisplayer queryResultDisplayer = QueryResultDisplayersRegistry.getInstance().getQueryResultDisplayer(displayerName);
        if (queryResultDisplayer != null) {
            queryResultDisplayer.getDisplayer().displayQueryResult(result);
        } else {
            String message = NLS.bind((String)"Query Displayer with name \"{0}\" not found", (Object)displayerName);
            MoDiscoLogger.logError((String)message, (Plugin)Activator.getDefault());
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"No Query Displayer", (String)message);
        }
    }

    private ModelQuery getSelectedQuery() {
        IStructuredSelection structuredSelection;
        Object selectedElement;
        ISelection selection = this.querySelectionFilteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ModelQuery) {
            ModelQuery selectedQuery = (ModelQuery)selectedElement;
            return selectedQuery;
        }
        return null;
    }

    private void createDisplayStyleComposite(Group executeGroup) {
        Composite displayStyleComposite = new Composite((Composite)executeGroup, 0);
        displayStyleComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        displayStyleComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(displayStyleComposite, 0);
        label.setText("Display result in: ");
        this.comboResultDisplayer = new Combo(displayStyleComposite, 12);
        List<QueryResultDisplayersRegistry.NamedQueryResultDisplayer> queryResultDisplayers = QueryResultDisplayersRegistry.getInstance().getQueryResultDisplayers();
        for (QueryResultDisplayersRegistry.NamedQueryResultDisplayer namedQueryResultDisplayer : queryResultDisplayers) {
            this.comboResultDisplayer.add(namedQueryResultDisplayer.getName());
        }
        this.comboResultDisplayer.select(0);
        this.comboResultDisplayer.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    public void setFocus() {
        this.querySelectionFilteredTree.setFocus();
    }

    public void setContext(List<EObject> selectedEObjects) {
        this.context.clear();
        this.context.addAll(selectedEObjects);
        this.refreshContextViewer();
    }

    public ContextInfo getContextInfo() {
        ContextInfo contextSelectionInfo = new ContextInfo(new ArrayList<EObject>(this.context));
        ISelection selection = this.contextViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof EObject)) continue;
                EObject eObject = (EObject)selectedElement;
                contextSelectionInfo.addSelectedEObject(eObject);
            }
        }
        return contextSelectionInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ContextInfo {
        private final List<EObject> eObjects;
        private final List<EObject> selectedEObjects = new ArrayList<EObject>();

        private ContextInfo(List<EObject> eObjects) {
            this.eObjects = eObjects;
        }

        public List<EObject> getEObjects() {
            return this.eObjects;
        }

        private void addSelectedEObject(EObject eObject) {
            this.selectedEObjects.add(eObject);
        }

        public List<EObject> getSelectedEObjects() {
            return this.selectedEObjects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LayoutStyle {
        Horizontal,
        Vertical;

    }

    private final class QueryContextLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private final Color gray;

        public QueryContextLabelProvider() {
            Display display = Display.getCurrent();
            RGB rgbGray = new RGB(128, 128, 128);
            this.gray = new Color((Device)display, rgbGray);
        }

        public String getText(Object element) {
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                String prefix = "";
                EClass eClass = eObject.eClass();
                if (eClass != null) {
                    prefix = "[" + eClass.getName() + "] ";
                }
                return String.valueOf(prefix) + ModelUtils.getName((EObject)eObject);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            return ImageUtils.getImage((Object)element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof String) {
                return this.gray;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            this.gray.dispose();
        }
    }
}

