/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.kdm.uml2converter.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.actions.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelFromKdmModel
implements Discoverer {
    private final String sourceExtension = "kdm";
    private final String targetExtension = "uml";
    private final DiscoveryParameterImpl targetModel;
    private final DiscoveryParameterImpl targetUri;
    private final List<DiscoveryParameter> discovererParameters = new ArrayList<DiscoveryParameter>();

    public boolean isApplicableTo(Object source) {
        IFile iFile;
        String extension;
        boolean result = false;
        if (source instanceof IFile && (extension = (iFile = (IFile)source).getFileExtension()) != null && extension.equals("kdm")) {
            result = true;
        }
        return result;
    }

    public Resource discoverElement(Object source, URI target) {
        IPath path;
        Resource resource;
        block12: {
            resource = null;
            Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
            IFile iFile = (IFile)source;
            String sourcePath = iFile.getLocation().toString();
            Object tempPath = iFile.getLocation().removeFileExtension().addFileExtension("uml");
            if (target != null) {
                tempPath = target.isRelative() ? ResourcesPlugin.getWorkspace().getRoot().getFullPath().append(target.path()) : new Path(target.toFileString());
            }
            path = tempPath;
            AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(path.toString()) + ".log");
            logger.addHandler((Handler)logHandler);
            try {
                try {
                    KDMtoUML2Converter transfo = new KDMtoUML2Converter();
                    XMIResourceImpl kdmModel = new XMIResourceImpl();
                    kdmModel.setURI(URI.createFileURI((String)sourcePath));
                    URI outputURI = URI.createFileURI((String)path.toString());
                    transfo.getUML2ModelFromKDMModel((Resource)kdmModel, false, outputURI);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Error in discovery of java project", e);
                    logger.removeHandler((Handler)logHandler);
                    logHandler.close();
                    try {
                        iFile.getParent().refreshLocal(1, null);
                    }
                    catch (Exception exception) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                logger.removeHandler((Handler)logHandler);
                logHandler.close();
                try {
                    iFile.getParent().refreshLocal(1, null);
                }
                catch (Exception exception) {}
                throw throwable;
            }
            logger.removeHandler((Handler)logHandler);
            logHandler.close();
            try {
                iFile.getParent().refreshLocal(1, null);
            }
            catch (Exception exception) {}
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IFile ifile = root.getFileForLocation(path);
                    if (ifile != null && ifile.exists()) {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        return resource;
    }

    public String toString() {
        return Messages.DiscoverUmlModelFromKdmModel_4;
    }

    public DiscoverUmlModelFromKdmModel() {
        this.targetModel = new DiscoveryParameterImpl("TargetModel", DiscoveryParameterDirectionKind.out, Resource.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetModel);
        this.targetUri = new DiscoveryParameterImpl("TargetUri", DiscoveryParameterDirectionKind.in, URI.class, false);
        this.discovererParameters.add((DiscoveryParameter)this.targetUri);
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        Object value;
        URI targetUri = null;
        if (parameters.containsKey(this.targetUri) && (value = parameters.get(this.targetUri)) instanceof URI) {
            targetUri = (URI)value;
        }
        Resource result = this.discoverElement(source, targetUri);
        parameters.put((DiscoveryParameter)this.targetModel, result);
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        return Collections.unmodifiableList(this.discovererParameters);
    }
}

