/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class PathUtils {
    private PathUtils() {
    }

    public static InputStream getResourceStream(IPath resourcePath) {
        if (resourcePath.segmentCount() < 2) {
            return null;
        }
        String bundleID = resourcePath.segment(0);
        IPath path = resourcePath.removeFirstSegments(1);
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath);
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            try {
                return file.getContents();
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            return null;
        }
        URL resourceURL = bundle.getResource(path.toString());
        try {
            return resourceURL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

