/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.role.ui.views;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.common.core.builder.AbstractMoDiscoCatalog;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.common.core.utils.ImageUtils;
import org.eclipse.gmt.modisco.infra.role.Role;
import org.eclipse.gmt.modisco.infra.role.RolePackage;
import org.eclipse.gmt.modisco.infra.role.RoleSet;
import org.eclipse.gmt.modisco.infra.role.core.RoleSetCatalog;
import org.eclipse.gmt.modisco.infra.role.ui.Activator;
import org.eclipse.gmt.modisco.infra.role.ui.Messages;
import org.eclipse.gmt.modisco.infra.role.ui.views.RoleSetContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class RoleView
extends ViewPart
implements AbstractMoDiscoCatalog.ModiscoCatalogChangeListener {
    private static final int JOB_SCHEDULE_DELAY = 500;
    private static final int COLUMN_WIDTH = 200;
    private TreeViewer roleSetViewer;
    private TreeViewerColumn nameColumn;
    private TreeViewerColumn locationColumn;
    private Job refreshJob = null;
    private TreeViewerColumn defaultColumn;
    private TreeViewerColumn extendsColumn;

    public TreeViewer getRoleSetViewer() {
        return this.roleSetViewer;
    }

    public TreeViewerColumn getNameColumn() {
        return this.nameColumn;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.roleSetViewer = new TreeViewer(parent, 66308);
        this.roleSetViewer.getTree().setLinesVisible(true);
        this.roleSetViewer.getTree().setHeaderVisible(true);
        this.roleSetViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)RoleView.this.getRoleSetViewer().getSelection();
                EObject modelElement = (EObject)selection.getFirstElement();
                RoleSet roleSet = null;
                if (modelElement instanceof RoleSet) {
                    roleSet = (RoleSet)modelElement;
                } else if (modelElement instanceof Role) {
                    Role role = (Role)modelElement;
                    roleSet = role.getEPackage();
                }
                if (roleSet != null) {
                    java.net.URI uri = null;
                    try {
                        String uriString = RoleSetCatalog.getSingleton().getURI(roleSet.getName()).toString();
                        uri = java.net.URI.create(uriString);
                        if ("file".equals(uri.getScheme())) {
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(roleSet.eResource().getURI().toString()), (String)Activator.ROLE_EDITOR_ID, (boolean)true);
                        } else {
                            URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                            IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)Activator.ROLE_EDITOR_ID, (boolean)true);
                        }
                    }
                    catch (Exception e) {
                        MoDiscoLogger.logError((Throwable)e, (String)("Failed to open: " + uri), (Plugin)Activator.getDefault());
                    }
                }
            }
        });
        this.createNameColumn();
        this.createExtendsColumn();
        this.createLocationColumn();
        this.createDefaultColumn();
        this.roleSetViewer.setContentProvider((IContentProvider)new RoleSetContentProvider(RolePackage.eINSTANCE.getRoleStructuralFeature()));
        this.getSite().setSelectionProvider((ISelectionProvider)this.roleSetViewer);
        this.refresh(false);
        RoleSetCatalog.getSingleton().addChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    private void createLocationColumn() {
        this.locationColumn = new TreeViewerColumn(this.roleSetViewer, 0);
        this.locationColumn.getColumn().setText(Messages.RoleView_location);
        this.locationColumn.getColumn().setWidth(400);
        this.locationColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof RoleSet)) {
                    return "";
                }
                RoleSet roleSet = (RoleSet)element;
                return RoleSetCatalog.getSingleton().getURI(roleSet.getName()).toString();
            }
        });
        this.addSorter(this.locationColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                RoleSet roleSet1 = (RoleSet)e1;
                RoleSet roleSet2 = (RoleSet)e2;
                String uri1 = RoleSetCatalog.getSingleton().getURI(roleSet1.getName()).toString();
                String uri2 = RoleSetCatalog.getSingleton().getURI(roleSet2.getName()).toString();
                int compare = uri1.compareTo(uri2);
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createNameColumn() {
        this.nameColumn = new TreeViewerColumn(this.roleSetViewer, 0);
        this.nameColumn.getColumn().setText(Messages.RoleView_name);
        this.nameColumn.getColumn().setWidth(200);
        this.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RoleSet) {
                    RoleSet roleSet = (RoleSet)element;
                    return roleSet.getName();
                }
                if (element instanceof Role) {
                    Role role = (Role)element;
                    return role.getName();
                }
                if (element instanceof EStructuralFeature) {
                    EStructuralFeature feature = (EStructuralFeature)element;
                    return feature.getName();
                }
                return "";
            }

            public Image getImage(Object element) {
                return ImageUtils.getImage((Object)element);
            }
        });
        this.addSorter(this.nameColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                RoleSet roleSet1 = (RoleSet)e1;
                RoleSet roleSet2 = (RoleSet)e2;
                int compare = roleSet1.getName().compareTo(roleSet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createDefaultColumn() {
        this.defaultColumn = new TreeViewerColumn(this.roleSetViewer, 0);
        this.defaultColumn.getColumn().setText(Messages.RoleView_1);
        this.defaultColumn.getColumn().setWidth(200);
        this.defaultColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RoleSet roleSet;
                EAnnotation annotation;
                if (element instanceof RoleSet && (annotation = (roleSet = (RoleSet)element).getEAnnotation("default")) != null && annotation.getReferences().size() == 1 && annotation.getReferences().get(0) instanceof EPackage) {
                    EPackage ePackage = (EPackage)annotation.getReferences().get(0);
                    return String.valueOf(ePackage.getName()) + " " + ePackage.getNsURI();
                }
                return "";
            }
        });
        this.addSorter(this.defaultColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                RoleSet roleSet1 = (RoleSet)e1;
                RoleSet roleSet2 = (RoleSet)e2;
                int compare = roleSet1.getName().compareTo(roleSet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void createExtendsColumn() {
        this.extendsColumn = new TreeViewerColumn(this.roleSetViewer, 0);
        this.extendsColumn.getColumn().setText("Extends");
        this.extendsColumn.getColumn().setWidth(200);
        this.extendsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof RoleSet) {
                    RoleSet roleSet = (RoleSet)element;
                    return String.valueOf(roleSet.getExtendedPackage().getName()) + " " + roleSet.getExtendedPackage().getNsURI();
                }
                return "";
            }
        });
        this.addSorter(this.extendsColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                TreeViewer structuredViewer;
                RoleSet roleSet1 = (RoleSet)e1;
                RoleSet roleSet2 = (RoleSet)e2;
                int compare = roleSet1.getName().compareTo(roleSet2.getName());
                if (viewer instanceof TreeViewer && (structuredViewer = (TreeViewer)viewer).getTree().getSortDirection() == 1024) {
                    compare *= -1;
                }
                return compare;
            }
        });
    }

    private void addSorter(final TreeViewerColumn column, final ViewerSorter viewerSorter) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewer treeView = RoleView.this.getRoleSetViewer();
                treeView.setSorter(viewerSorter);
                treeView.getTree().setSortColumn(column.getColumn());
                if (treeView.getTree().getSortDirection() == 128) {
                    treeView.getTree().setSortDirection(1024);
                } else if (treeView.getTree().getSortDirection() == 1024) {
                    treeView.getTree().setSortDirection(128);
                } else {
                    treeView.getTree().setSortDirection(128);
                }
                treeView.refresh();
            }
        });
    }

    public void setFocus() {
        this.roleSetViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        RoleSetCatalog.getSingleton().removeChangeListener((AbstractMoDiscoCatalog.ModiscoCatalogChangeListener)this);
    }

    public void changed(EObject changedRoleSet, IFile file) {
        this.refresh(true);
    }

    public void added(EObject addedRoleSet, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile roleSetFile) {
        this.refresh(true);
    }

    private void refresh(boolean delayed) {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.RoleView_JobName_refreshingRoleSetsView){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            RoleView.this.getRoleSetViewer().setInput((Object)RoleSetCatalog.getSingleton().getAllRoleSets().toArray());
                            RoleView.this.getNameColumn().getColumn().pack();
                            RoleView.this.getRoleSetViewer().refresh();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        if (delayed) {
            this.refreshJob.cancel();
            this.refreshJob.setPriority(50);
            this.refreshJob.schedule(500L);
        } else {
            this.refreshJob.schedule();
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
    }
}

