/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.actions.IBrowserActionBarContributor;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.QueryExecutionView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ExecuteQueryAction
extends Action {
    private final IBrowserActionBarContributor browserActionBarContributor;

    public ExecuteQueryAction(IBrowserActionBarContributor browserActionBarContributor) {
        super(Messages.ExecuteQueryAction_executeQuery);
        this.browserActionBarContributor = browserActionBarContributor;
    }

    public void run() {
        ISelection selection = this.browserActionBarContributor.getSelection();
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof ModelElementItem)) continue;
                ModelElementItem element = (ModelElementItem)selectedElement;
                selectedEObjects.add(element.getEObject());
            }
        }
        IViewPart view = this.openQueryExecutionView();
        if (selectedEObjects.size() > 0 && view instanceof QueryExecutionView) {
            QueryExecutionView queryExecutionView = (QueryExecutionView)view;
            queryExecutionView.setContext(selectedEObjects);
        }
    }

    private IViewPart openQueryExecutionView() {
        try {
            IWorkbenchPage activePage;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (activePage = window.getActivePage()) != null) {
                return activePage.showView("org.eclipse.gmt.modisco.infra.query.ui.queryExecutionView");
            }
        }
        catch (PartInitException e) {
            MoDiscoBrowserPlugin.logException(e);
        }
        return null;
    }
}

