/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.core;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.InstancesForMetaclasses;
import org.eclipse.gmt.modisco.infra.browser.customization.CustomizationEngine;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.browser.util.EMFUtil;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstancesForMetaclass {
    private final ArrayList<EObject> elements = new ArrayList();
    private final ArrayList<EObject> derivedElements = new ArrayList();
    private final ArrayList<InstancesForMetaclass> subclasses = new ArrayList();
    private final EClass eClass;
    private final InstancesForMetaclasses instancesForMetaclasses;
    private final BrowserConfiguration browserConfiguration;
    private ArrayList<EObject> cachedElements = null;
    private int cachedElementsModCount = -1;
    private ArrayList<EObject> cachedDerivedElements = null;
    private int cachedDerivedElementsModCount = -1;
    private String classQualifiedName = null;
    private Object parent;

    public InstancesForMetaclass(EClass eClass, InstancesForMetaclasses instancesForMetaclasses, BrowserConfiguration browserConfiguration) {
        this.eClass = eClass;
        this.instancesForMetaclasses = instancesForMetaclasses;
        this.browserConfiguration = browserConfiguration;
    }

    public ArrayList<EObject> getElements() {
        if (this.cachedElements == null || this.cachedElementsModCount != this.browserConfiguration.getModCount()) {
            CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
            this.cachedElements = customizationEngine.filterVisible(this.elements);
            this.cachedElementsModCount = this.browserConfiguration.getModCount();
        }
        return this.cachedElements;
    }

    public ArrayList<EObject> getDerivedElements() {
        if (this.cachedDerivedElements == null || this.cachedDerivedElementsModCount != this.browserConfiguration.getModCount()) {
            CustomizationEngine customizationEngine = this.browserConfiguration.getCustomizationEngine();
            this.cachedDerivedElements = customizationEngine.filterVisible(this.derivedElements);
            this.cachedDerivedElementsModCount = this.browserConfiguration.getModCount();
        }
        return this.cachedDerivedElements;
    }

    public void add(EObject object, boolean addDerived) {
        this.elements.add(object);
        if (addDerived) {
            this.addDerived(object);
        }
    }

    public void facetAdd(EObject object) {
        this.elements.add(object);
    }

    private void addDerived(EObject object) {
        EList allSuperTypes = this.eClass.getEAllSuperTypes();
        for (EClass superclass : allSuperTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName((EClassifier)superclass));
            if (instancesForSuperclass != null) {
                instancesForSuperclass.derivedElements.add(object);
                continue;
            }
            MoDiscoBrowserPlugin.logWarning(NLS.bind((String)Messages.InstancesForMetaclass_notFound, (Object)EMFUtil.getMetaclassQualifiedName((EClassifier)superclass)));
        }
    }

    public void remove(EObject object) {
        object.eAdapters().remove((Object)this);
        this.elements.remove(object);
        this.removeDerived(object, false);
    }

    private void removeDerived(EObject object, boolean derived) {
        if (derived) {
            this.derivedElements.remove(object);
        }
        EList allSuperTypes = this.eClass.getEAllSuperTypes();
        for (EClass superclass : allSuperTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName((EClassifier)superclass));
            instancesForSuperclass.removeDerived(object, true);
        }
    }

    public int size() {
        return this.getElements().size();
    }

    public int totalSize() {
        return this.getElements().size() + this.getDerivedElements().size();
    }

    public EClass getEClass() {
        return this.eClass;
    }

    public String getClassQualifiedName() {
        if (this.classQualifiedName == null) {
            this.classQualifiedName = EMFUtil.getMetaclassQualifiedName((EClassifier)this.getEClass());
        }
        return this.classQualifiedName;
    }

    public void setParent(Object parent) {
        this.parent = parent;
    }

    public Object getParent() {
        return this.parent;
    }

    public void buildParentsSubclasses() {
        EList superTypes = this.eClass.getESuperTypes();
        for (EClass superclass : superTypes) {
            InstancesForMetaclass instancesForSuperclass = this.instancesForMetaclasses.getInstancesForMetaclass(EMFUtil.getMetaclassQualifiedName((EClassifier)superclass));
            if (instancesForSuperclass != null) {
                instancesForSuperclass.addSubclass(this);
                continue;
            }
            if (this.eClass instanceof Facet) continue;
            MoDiscoBrowserPlugin.logWarning(NLS.bind((String)Messages.InstancesForMetaclass_notFound, (Object)EMFUtil.getMetaclassQualifiedName((EClassifier)superclass)));
        }
    }

    public void clearSubclasses() {
        this.subclasses.clear();
    }

    public InstancesForMetaclass[] getSubclasses() {
        return this.subclasses.toArray(new InstancesForMetaclass[this.subclasses.size()]);
    }

    private void addSubclass(InstancesForMetaclass instancesForMetaclass) {
        this.subclasses.add(instancesForMetaclass);
    }

    public String toString() {
        return String.valueOf(this.getClassQualifiedName()) + " " + this.elements.size();
    }
}

