/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.infra.browser.custom.ui.views;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.infra.browser.custom.MetamodelView;
import org.eclipse.gmt.modisco.infra.browser.custom.core.CustomizationsCatalog;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Activator;
import org.eclipse.gmt.modisco.infra.browser.custom.ui.Messages;
import org.eclipse.gmt.modisco.infra.browser.util.ColorProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class CustomizationsView
extends ViewPart
implements CustomizationsCatalog.CustomizationChangeListener {
    private static final int QUERY_SETS_COLUMN_WIDTH = 400;
    private static final int METAMODEL_COLUMN_WIDTH = 300;
    private static final int NAME_COLUMN_WIDTH = 200;
    private TableViewer fViewer;
    private TableViewerColumn nameColumn;
    private TableViewerColumn metamodelColumn;
    private TableViewerColumn querySetsColumn;
    private Job refreshJob = null;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fViewer = new TableViewer(parent, 66308);
        this.fViewer.getTable().setLinesVisible(true);
        this.fViewer.getTable().setHeaderVisible(true);
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)CustomizationsView.this.fViewer.getSelection();
                MetamodelView metamodelView = (MetamodelView)selection.getFirstElement();
                try {
                    java.net.URI uri = new java.net.URI(metamodelView.getLocation());
                    if ("file".equals(uri.getScheme())) {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (java.net.URI)new java.net.URI(metamodelView.getLocation()), (String)"org.eclipse.gmt.modisco.infra.browser.custom.editor", (boolean)true);
                    } else {
                        URIEditorInput uriEditorInput = new URIEditorInput(URI.createURI((String)uri.toString()));
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)uriEditorInput, (String)"org.eclipse.gmt.modisco.infra.browser.custom.editor", (boolean)true);
                    }
                }
                catch (Exception e) {
                    Activator.logException(e);
                }
            }
        });
        this.nameColumn = new TableViewerColumn(this.fViewer, 0);
        this.nameColumn.getColumn().setText(Messages.CustomizationsView_nameColumn);
        this.nameColumn.getColumn().setWidth(200);
        this.nameColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                return metamodelView.getName();
            }

            public Color getForeground(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                if (!metamodelView.getLocation().startsWith("file:/")) {
                    return ColorProvider.getInstance().getExternalResourceColor();
                }
                return super.getForeground(element);
            }
        });
        this.addSorter(this.nameColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                MetamodelView view1 = (MetamodelView)e1;
                MetamodelView view2 = (MetamodelView)e2;
                return view1.getName().compareTo(view2.getName());
            }
        });
        this.metamodelColumn = new TableViewerColumn(this.fViewer, 0);
        this.metamodelColumn.getColumn().setText(Messages.CustomizationsView_metamodelColumn);
        this.metamodelColumn.getColumn().setWidth(300);
        this.metamodelColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                return metamodelView.getMetamodelURI();
            }
        });
        this.addSorter(this.metamodelColumn, new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                MetamodelView view1 = (MetamodelView)e1;
                MetamodelView view2 = (MetamodelView)e2;
                return view1.getMetamodelURI().compareTo(view2.getMetamodelURI());
            }
        });
        this.querySetsColumn = new TableViewerColumn(this.fViewer, 0);
        this.querySetsColumn.getColumn().setText(Messages.CustomizationsView_querySetsColumn);
        this.querySetsColumn.getColumn().setWidth(400);
        this.querySetsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                MetamodelView metamodelView = (MetamodelView)element;
                if (metamodelView.isAllQuerySetsAvailable()) {
                    return Messages.CustomizationsView_allQuerySets;
                }
                EList availableQuerySets = metamodelView.getAvailableQuerySets();
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < availableQuerySets.size()) {
                    builder.append((String)availableQuerySets.get(i));
                    if (i != availableQuerySets.size() - 1) {
                        builder.append(", ");
                    }
                    ++i;
                }
                return builder.toString();
            }
        });
        this.fViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                List metamodelViews = (List)inputElement;
                return metamodelViews.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.refresh(false);
        CustomizationsCatalog.getInstance().addChangeListener((CustomizationsCatalog.CustomizationChangeListener)this);
    }

    private void addSorter(final TableViewerColumn column, final ViewerSorter viewerSorter) {
        column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomizationsView.this.fViewer.getSorter() == null || CustomizationsView.this.fViewer.getSorter() != viewerSorter) {
                    CustomizationsView.this.fViewer.setSorter(viewerSorter);
                    CustomizationsView.this.fViewer.getTable().setSortColumn(column.getColumn());
                    CustomizationsView.this.fViewer.getTable().setSortDirection(128);
                } else {
                    CustomizationsView.this.fViewer.setSorter(null);
                    CustomizationsView.this.fViewer.getTable().setSortDirection(0);
                }
            }
        });
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        CustomizationsCatalog.getInstance().removeChangeListener((CustomizationsCatalog.CustomizationChangeListener)this);
    }

    public void changed(MetamodelView changedCustomization, IFile file) {
        this.refresh(true);
    }

    public void added(MetamodelView addedCustomization, IFile file) {
        this.refresh(true);
    }

    public void removed(IFile customizationFile) {
        this.refresh(true);
    }

    private void refresh(boolean delayed) {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.CustomizationsView_jobName_RefreshCustomizationsView){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            CustomizationsView.this.fViewer.setInput((Object)CustomizationsCatalog.getInstance().getAllCustomizations());
                            CustomizationsView.this.nameColumn.getColumn().pack();
                            CustomizationsView.this.metamodelColumn.getColumn().pack();
                            CustomizationsView.this.querySetsColumn.getColumn().pack();
                            CustomizationsView.this.fViewer.refresh();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        }
        if (delayed) {
            this.refreshJob.cancel();
            this.refreshJob.setPriority(50);
            this.refreshJob.schedule(500L);
        } else {
            this.refreshJob.schedule();
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException e) {
                Activator.logException(e);
            }
        }
    }
}

