/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Report;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client.JavaDiscovererCDO;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client.nousage.JavaDiscovererCDONoUsages;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.server.DerbyCDOServerNoAudits;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererClassicalEMF;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFMinimalEObject;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererEMFNoUsages;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client.JavaDiscovererIncrementalEMF;
import org.eclipse.gmt.modisco.java.discoverer.tests.Server;
import org.eclipse.gmt.modisco.java.discoverer.tests.cdo.server.DerbyCDOServer;
import org.eclipse.gmt.modisco.java.discoverer.tests.emfstat.DiscoverJavaModelFromJavaProjectEMFStat;
import org.eclipse.jdt.core.IJavaProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRunBenchmark
implements Discoverer {
    private static final int INITIAL_PORT = 2036;
    private int port = 2036;
    protected static final String LAUNCHTYPE = "org.eclipse.pde.ui.RuntimeWorkbench";
    private IProject statProject;

    public IProject getStatProject() {
        return this.statProject;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        }
        return result;
    }

    public Resource discoverElement(Object source, URI target) {
        this.discoverElement(source, new HashMap<DiscoveryParameter, Object>());
        return null;
    }

    protected void copyLog() {
        File platformLogFile = Platform.getLogFileLocation().toFile();
        File localLogFile = this.statProject.getFile("log.log").getLocation().toFile();
        Reader reader = null;
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(localLogFile), "UTF-8");
            reader = new InputStreamReader((InputStream)new FileInputStream(platformLogFile), "UTF-8");
            this.copy(reader, writer);
        }
        catch (Exception exception) {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    ((Writer)writer).close();
                }
            }
            catch (IOException e1) {
                MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(Reader input, Writer output) {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            try {
                reader = new BufferedReader(input);
                writer = new BufferedWriter(output);
                String line = reader.readLine();
                while (reader.ready()) {
                    if (line == null) {
                        return;
                    }
                    writer.write(line);
                    writer.newLine();
                    line = reader.readLine();
                }
                return;
            }
            catch (IOException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (writer == null) return;
                    writer.close();
                    return;
                }
                catch (IOException e1) {
                    MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
                    return;
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                MoDiscoLogger.logError((Throwable)e1, (Plugin)Activator.getDefault());
            }
        }
    }

    protected void disco(Object source, Class<? extends DiscoverJavaModelFromJavaProjectEMFStat> discovererClass) {
        try {
            DiscoverJavaModelFromJavaProjectEMFStat discoverer = discovererClass.newInstance();
            discoverer.setStatProject(this.statProject);
            HashMap<DiscoveryParameter, Boolean> map = new HashMap<DiscoveryParameter, Boolean>();
            map.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, true);
            discoverer.discoverElement(source, map);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    protected void serverAndDisco(Object source, Class<? extends Server> serverClass, Class<? extends JavaDiscovererCDO> discovererClass) {
        try {
            Status status = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", "Starting server: " + serverClass.getSimpleName());
            Activator.getDefault().getLog().log((IStatus)status);
            ++this.port;
            Server server = serverClass.newInstance();
            server.start("db" + System.currentTimeMillis(), this.port);
            Thread.sleep(60000L);
            Status status2 = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", "Starting discovery");
            Activator.getDefault().getLog().log((IStatus)status2);
            JavaDiscovererCDO discoverer = discovererClass.newInstance();
            discoverer.setStatProject(this.statProject);
            discoverer.setPort(this.port);
            discoverer.setServerDescription(server.getDescription());
            discoverer.discoverElement(source, URI.createURI((String)""));
            Status status3 = new Status(1, "org.eclipse.gmt.modisco.java.discoverer.benchmark", "Stopping server");
            Activator.getDefault().getLog().log((IStatus)status3);
            server.stop();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        this.initStatProject((IJavaProject)source);
        this.serverAndDisco(source, DerbyCDOServerNoAudits.class, JavaDiscovererCDO.class);
        this.serverAndDisco(source, DerbyCDOServerNoAudits.class, JavaDiscovererCDONoUsages.class);
        this.serverAndDisco(source, DerbyCDOServer.class, JavaDiscovererCDO.class);
        this.disco(source, JavaDiscovererIncrementalEMF.class);
        this.disco(source, JavaDiscovererEMFNoUsages.class);
        this.disco(source, JavaDiscovererEMFMinimalEObject.class);
        this.disco(source, JavaDiscovererClassicalEMF.class);
        this.copyLog();
        new Report(this.statProject).generate();
    }

    public List<DiscoveryParameter> getDiscovererParameters() {
        return null;
    }

    protected void initStatProject(IJavaProject sourceProject) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        this.statProject = ws.getRoot().getProject("statistics_" + System.currentTimeMillis() + "_" + sourceProject.getElementName());
        try {
            this.statProject.create((IProgressMonitor)new NullProgressMonitor());
            this.statProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.eclipse.gmt.modisco.java.discoverer.benchmark", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            this.statProject = null;
        }
    }

    public ILaunch launch(String application) throws Exception {
        String name = "";
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCHTYPE);
        ILaunchConfigurationWorkingCopy launchConfiguration = null;
        launchConfiguration = type.newInstance(null, name);
        launchConfiguration = launchConfiguration.getWorkingCopy().getParent().doSave();
        ILaunchConfigurationWorkingCopy copy = launchConfiguration.getWorkingCopy();
        this.initAttribute(copy, "org.eclipse.gmt.modisco.java.discoverer.benchmark." + application);
        launchConfiguration = copy.doSave();
        ILaunch iLaunch = launchConfiguration.launch("run", (IProgressMonitor)new NullProgressMonitor());
        return iLaunch;
    }

    protected void initAttribute(ILaunchConfigurationWorkingCopy copy, String application) {
        copy.setAttribute("append.args", true);
        copy.setAttribute("application", application);
        copy.setAttribute("askclear", true);
        copy.setAttribute("automaticAdd", true);
        copy.setAttribute("automaticValidate", false);
        copy.setAttribute("bootstrap", "");
        copy.setAttribute("checked", "[NONE]");
        copy.setAttribute("clearConfig", false);
        copy.setAttribute("clearws", false);
        copy.setAttribute("clearwslog", false);
        copy.setAttribute("configLocation", "${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/New_configuration");
        copy.setAttribute("includeOptional", true);
        copy.setAttribute("location", "${workspace_loc}/../runtime-New_configuration");
        copy.setAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS", "-os ${target.os} -ws ${target.ws} -arch ${target.arch} -nl ${target.nl} -consoleLog -port " + this.port);
        copy.setAttribute("org.eclipse.jdt.launching.SOURCE_PATH_PROVIDER", "org.eclipse.pde.ui.workbenchClasspathProvider");
        copy.setAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", "-Xms40m -Xmx512m");
        copy.setAttribute("pde.version", "3.3");
        copy.setAttribute("product", "org.eclipse.platform.ide");
        copy.setAttribute("show_selected_only", false);
        copy.setAttribute("templateConfig", "${target_home}\\configuration\\config.ini");
        copy.setAttribute("tracing", false);
        copy.setAttribute("useDefaultConfig", true);
        copy.setAttribute("useDefaultConfigArea", true);
        copy.setAttribute("useProduct", false);
        copy.setAttribute("usefeatures", false);
        copy.setAttribute("default", true);
    }
}

