/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.server;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.gmt.modisco.java.discoverer.tests.cdo.server.AbstractCDOServer;
import org.eclipse.net4j.db.IDBAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2CDOServer
extends AbstractCDOServer {
    protected DataSource getDataSource(String dbName) {
        EmbeddedDataSource dataSource = new EmbeddedDataSource();
        String javaIoTmpdirStr = System.getProperty("java.io.tmpdir");
        dataSource.setDatabaseName(String.valueOf(javaIoTmpdirStr) + dbName);
        dataSource.setCreateDatabase("create");
        return dataSource;
    }

    protected Map<String, String> getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "gastro");
        props.put("supportingAudits", Boolean.TRUE.toString());
        props.put("verifyingRevisions", Boolean.FALSE.toString());
        props.put("currentLRUCapacity", CURRENT_LRU_CAPACITY.toString());
        props.put("revisedLRUCapacity", REVISED_LRU_CAPACITY.toString());
        return props;
    }

    protected IMappingStrategy getMappingStrategy() {
        IMappingStrategy mappingStrategy = CDODBUtil.createHorizontalMappingStrategy((boolean)true);
        return mappingStrategy;
    }

    public String getDescription() {
        return "H2, SUPPORTING_AUDITS";
    }

    protected IDBAdapter getDBAdapter() {
        return null;
    }
}

