/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.xml.internal.resource;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.gmt.modisco.xml.Attribute;
import org.eclipse.gmt.modisco.xml.CDATA;
import org.eclipse.gmt.modisco.xml.Comment;
import org.eclipse.gmt.modisco.xml.DocumentTypeDeclaration;
import org.eclipse.gmt.modisco.xml.Element;
import org.eclipse.gmt.modisco.xml.Namespace;
import org.eclipse.gmt.modisco.xml.Node;
import org.eclipse.gmt.modisco.xml.ProcessingInstruction;
import org.eclipse.gmt.modisco.xml.Root;
import org.eclipse.gmt.modisco.xml.Text;

public class GenericXMLWriter
extends PrintWriter {
    protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    public GenericXMLWriter(OutputStream output) throws UnsupportedEncodingException {
        super(new OutputStreamWriter(output, "UTF8"));
        this.println(XML_VERSION);
    }

    public final void serialize(Element element) {
        this.startTag(element);
        if (element.getChildren() != null) {
            for (Node child : element.getChildren()) {
                String text;
                if (child instanceof Element) {
                    this.serialize((Element)child);
                    continue;
                }
                if (child instanceof CDATA) {
                    text = ((CDATA)child).getName();
                    this.print("<![CDATA[" + text + "]]>");
                    continue;
                }
                if (child instanceof Text) {
                    text = ((Text)child).getName();
                    this.print(GenericXMLWriter.getEscaped(text));
                    continue;
                }
                if (child instanceof Comment) {
                    text = "<!--" + ((Comment)child).getName() + "-->";
                    this.print(text);
                    continue;
                }
                if (!(child instanceof ProcessingInstruction)) continue;
                this.printPI((ProcessingInstruction)child);
            }
        }
        this.endTag(element);
    }

    private void startTag(Element element) {
        Root root;
        if (element instanceof Root) {
            root = (Root)element;
            if (root.getDtd() != null) {
                this.printDTD(root.getDtd());
            }
            if (root.getLeadingPIs() != null) {
                for (ProcessingInstruction pi : root.getLeadingPIs()) {
                    this.printPI(pi);
                    this.println();
                }
            }
        }
        this.print("<");
        this.print(element.getName());
        if (element instanceof Root && (root = (Root)element).getNamespaces() != null) {
            for (Namespace ns : root.getNamespaces()) {
                if (ns.getName().length() > 0) {
                    this.printAttribute("xmlns:" + ns.getName(), ns.getValue());
                    continue;
                }
                this.printAttribute("xmlns", ns.getValue());
            }
        }
        if (element.getChildren() != null) {
            for (Node child : element.getChildren()) {
                if (!(child instanceof Attribute)) continue;
                Attribute attr = (Attribute)child;
                this.printAttribute(attr.getName(), attr.getValue());
            }
        }
        this.print(">");
    }

    private void endTag(Element element) {
        this.print("</" + element.getName() + ">");
    }

    private void printAttribute(String key, String value) {
        this.print(" ");
        this.print(key);
        this.print("=\"");
        this.print(GenericXMLWriter.getEscaped(value));
        this.print("\"");
    }

    private void printDTD(DocumentTypeDeclaration dtd) {
        this.print("\n<!DOCTYPE ");
        this.print(dtd.getName());
        this.print("\n\t\"");
        this.print(dtd.getPublicID());
        this.print("\"\n\t\"");
        this.print(dtd.getSystemID());
        this.print("\">");
    }

    private void printPI(ProcessingInstruction pi) {
        this.print("<?");
        this.print(pi.getName());
        this.print(" ");
        this.print(pi.getData());
        this.print("?>");
    }

    private static void appendEscapedChar(StringBuffer buffer, char c) {
        String replacement = GenericXMLWriter.getReplacement(c);
        if (replacement != null) {
            buffer.append('&');
            buffer.append(replacement);
            buffer.append(';');
        } else {
            buffer.append(c);
        }
    }

    private static String getEscaped(String s) {
        StringBuffer result = new StringBuffer(s.length() + 10);
        int i = 0;
        while (i < s.length()) {
            GenericXMLWriter.appendEscapedChar(result, s.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static String getReplacement(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

