/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.common.core.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmt.modisco.common.core.CommonModiscoActivator;
import org.eclipse.gmt.modisco.common.core.protocol.ModiscoURIHandler;
import org.eclipse.gmt.modisco.common.core.resource.IMoDiscoResourceListener;
import org.eclipse.gmt.modisco.common.core.resource.MoDiscoResourceListenerGroup;

public final class MoDiscoResourceSet
extends ResourceSetImpl {
    private static final String DEBUG_ID = "org.eclipse.gmt.modisco.common.core/debug/MoDiscoResourceSet/debug";
    public static final boolean DEBUG = CommonModiscoActivator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.gmt.modisco.common.core/debug/MoDiscoResourceSet/debug")) != false;
    private static MoDiscoResourceSet resourceSet = null;
    private final Map<String, MoDiscoResourceListenerGroup> listenerGroupMap = new HashMap<String, MoDiscoResourceListenerGroup>();

    private MoDiscoResourceSet() {
    }

    public static MoDiscoResourceSet getResourceSetSingleton() {
        if (resourceSet == null) {
            resourceSet = new MoDiscoResourceSet();
        }
        return resourceSet;
    }

    public Resource getResource(URI uri, IMoDiscoResourceListener listener) throws IOException {
        this.setPackageRegistry(EPackage.Registry.INSTANCE);
        if (DEBUG) {
            Status status = new Status(1, "org.eclipse.gmt.modisco.common", "[" + ((Object)((Object)this)).getClass().getSimpleName() + ".getResource(URI,Listener)] " + uri.toString());
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
        for (Resource existingResource : this.getResources()) {
            if (!existingResource.getURI().equals((Object)uri)) continue;
            existingResource.unload();
            break;
        }
        Resource resource = super.getResource(uri, true);
        resource.load(Collections.EMPTY_MAP);
        this.addListenerToReferedResource(resource, listener);
        return resource;
    }

    private void addListenerToReferedResource(Resource resource, IMoDiscoResourceListener listener) {
        if (listener != null) {
            TreeIterator treeIterator = resource.getAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject = (EObject)treeIterator.next();
                for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                    Object object = eObject.eGet(feature);
                    if (object instanceof EObject) {
                        this.readEObject(resource, listener, object);
                        continue;
                    }
                    if (!(object instanceof EList)) continue;
                    EList list = (EList)object;
                    for (Object listObject : list) {
                        if (!(object instanceof EObject)) continue;
                        this.readEObject(resource, listener, listObject);
                    }
                }
            }
        }
    }

    private void readEObject(Resource resource, IMoDiscoResourceListener listener, Object object) {
        EObject referedEObject = (EObject)object;
        Resource referedObjectResource = referedEObject.eResource();
        if (referedObjectResource != resource) {
            if (referedObjectResource == null) {
                if (referedEObject.eIsProxy()) {
                    throw new RuntimeException("A proxy with a null resource has been found: " + EcoreUtil.getURI((EObject)referedEObject).toString());
                }
            } else {
                MoDiscoResourceListenerGroup listenerGroup = this.getListenerGroup(referedEObject.eResource().getURI());
                listenerGroup.addListener(listener, resource.getURI());
            }
        }
    }

    private MoDiscoResourceListenerGroup getListenerGroup(URI watchedResourceUri) {
        MoDiscoResourceListenerGroup listenerGroup = this.listenerGroupMap.get(watchedResourceUri.toString());
        if (listenerGroup == null) {
            listenerGroup = new MoDiscoResourceListenerGroup(watchedResourceUri);
            this.listenerGroupMap.put(watchedResourceUri.toString(), listenerGroup);
        }
        return listenerGroup;
    }

    public void aResourceHasBeenLoaded(Resource resource) {
        URI uri = resource.getURI();
        if (DEBUG) {
            Status status = new Status(1, "org.eclipse.gmt.modisco.common", "[" + ((Object)((Object)this)).getClass().getSimpleName() + ".aResourceAsBeenLoaded(Resource)] " + uri.toString());
            CommonModiscoActivator.getDefault().getLog().log((IStatus)status);
        }
        MoDiscoResourceListenerGroup listenerGroup = this.getListenerGroup(uri);
        listenerGroup.notifyChange();
    }

    public URIConverter getURIConverter() {
        if (this.uriConverter == null) {
            this.uriConverter = MoDiscoResourceSet.createURIConverter();
        }
        return this.uriConverter;
    }

    public static URIConverter createURIConverter() {
        List defaultHandlers = URIHandler.DEFAULT_HANDLERS;
        ArrayList<URIHandler> uriHandlers = new ArrayList<URIHandler>();
        if (CommonModiscoActivator.getDefault().getPreferenceStore().getBoolean("disable_default_urihandler")) {
            uriHandlers.add(new ModiscoURIHandler());
            for (URIHandler uriHandler : defaultHandlers) {
                if (uriHandler.getClass() == URIHandlerImpl.class) continue;
                uriHandlers.add(uriHandler);
            }
        } else {
            uriHandlers.add(new ModiscoURIHandler());
            uriHandlers.addAll(defaultHandlers);
        }
        return new ExtensibleURIConverterImpl(uriHandlers, (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
    }
}

