/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.java.io.java;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.java.IModelReader;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.JDTVisitor;
import org.eclipse.gmt.modisco.java.io.java.JDTVisitorUtils;
import org.eclipse.gmt.modisco.java.io.java.Messages;
import org.eclipse.gmt.modisco.java.io.java.MethodRedefinitionManager;
import org.eclipse.gmt.modisco.java.io.java.binding.BindingManager;
import org.eclipse.gmt.modisco.java.io.library.LibraryReader;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaReader
implements IModelReader {
    protected final boolean ISINCREMENTALDISCOVERING;
    protected final boolean IS_FULL_LEVEL_ANALYSIS;
    protected JavaFactory factory;
    protected Model resultModel;
    protected BindingManager globalBindings;
    protected Map<String, Object> options;
    private Collection<String> excludedElements;

    public JavaReader(JavaFactory factory) {
        this(factory, new HashMap<String, Object>(), false, true);
    }

    public JavaReader(JavaFactory factory, boolean isIncrementalDiscovering) {
        this(factory, new HashMap<String, Object>(), isIncrementalDiscovering, true);
    }

    public JavaReader(JavaFactory factory, Map<String, Object> options, boolean isIncrementalDiscovering, boolean isFullLevelAnalysis) {
        this(factory, options, isIncrementalDiscovering, isFullLevelAnalysis, new ArrayList<String>());
    }

    public JavaReader(JavaFactory factory, Map<String, Object> options, boolean isIncrementalDiscovering, boolean isFullLevelAnalysis, Collection<String> excludedElements) {
        this.factory = factory;
        this.ISINCREMENTALDISCOVERING = isIncrementalDiscovering;
        this.IS_FULL_LEVEL_ANALYSIS = isFullLevelAnalysis;
        this.options = options;
        this.excludedElements = excludedElements;
    }

    @Override
    public void readModel(Object source, Model resultModel, IProgressMonitor monitor) {
        this.readModel(source, resultModel, this.getBindingManager(), monitor);
    }

    @Override
    public void readModel(Object source, Model resultModel, BindingManager bindingManager, IProgressMonitor monitor) {
        block11: {
            if (source == null) {
                return;
            }
            this.resultModel = resultModel;
            this.globalBindings = bindingManager;
            if (this.ISINCREMENTALDISCOVERING) {
                this.globalBindings.enableIncrementalDiscovering(this.resultModel);
            } else {
                this.globalBindings.disableIncrementalDiscovering();
            }
            JDTVisitorUtils.initializePrimitiveTypes(this.factory, resultModel, this.globalBindings);
            try {
                if (source instanceof IJavaProject) {
                    IPackageFragment[] packageFolder;
                    IJavaProject javaProject = (IJavaProject)source;
                    if (resultModel.getName() == null || resultModel.getName().length() == 0) {
                        resultModel.setName(javaProject.getElementName());
                    }
                    IPackageFragment[] iPackageFragmentArray = packageFolder = javaProject.getPackageFragments();
                    int n = packageFolder.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragment parent = iPackageFragmentArray[n2];
                        if (parent.getCompilationUnits().length > 0 && !this.isElementExcluded(parent.getElementName())) {
                            monitor.subTask(String.valueOf(Messages.JavaReader_discoveringTask) + parent.getElementName());
                            this.parsePackage(javaProject, resultModel, parent, monitor);
                        }
                        if (monitor.isCanceled()) {
                            return;
                        }
                        ++n2;
                    }
                    break block11;
                }
                if (source instanceof ITypeRoot) {
                    this.parseTypeRoot((ITypeRoot)source);
                    break block11;
                }
                throw new IllegalArgumentException("Java reader can not handle source object : " + source.toString());
            }
            catch (Exception e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
            }
        }
    }

    protected boolean isElementExcluded(String name) {
        for (String exc : this.excludedElements) {
            if (!name.toLowerCase().startsWith(exc.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    protected void parseTypeRoot(ITypeRoot source) {
        CompilationUnit parsedCompilationUnit = this.parseCompilationUnit(source);
        String fileContent = null;
        String filePath = null;
        try {
            if (source instanceof ICompilationUnit) {
                IFile theIFile = ResourcesPlugin.getWorkspace().getRoot().getFile(parsedCompilationUnit.getJavaElement().getPath());
                fileContent = JavaReader.getContent(theIFile).toString();
                IProject project = source.getJavaProject().getProject();
                filePath = JavaReader.getRelativePath(project, parsedCompilationUnit);
            } else {
                fileContent = LibraryReader.getFileContent((IClassFile)source);
                filePath = LibraryReader.getPath((IClassFile)source);
            }
            this.visitCompilationUnit(this.resultModel, parsedCompilationUnit, filePath, fileContent);
        }
        catch (Exception e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)JavaActivator.getDefault());
        }
    }

    protected void parsePackage(IJavaProject javaProject, Model resultModel, IPackageFragment parent, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit[] children;
        ICompilationUnit[] iCompilationUnitArray = children = parent.getCompilationUnits();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICompilationUnit cu = iCompilationUnitArray[n2];
            boolean isExcluded = false;
            IType[] iTypeArray = cu.getTypes();
            int n3 = iTypeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IType t = iTypeArray[n4];
                if (this.isElementExcluded(t.getFullyQualifiedName())) {
                    isExcluded = true;
                    break;
                }
                ++n4;
            }
            if (!isExcluded) {
                this.parseTypeRoot((ITypeRoot)cu);
            }
            if (monitor.isCanceled()) {
                return;
            }
            ++n2;
        }
        if (this.ISINCREMENTALDISCOVERING) {
            this.reset();
        }
    }

    protected void visitCompilationUnit(Model resultModel, CompilationUnit parsedCompilationUnit, String filePath, String fileContent) {
        JDTVisitor jdtVisitor = new JDTVisitor(this.factory, resultModel, this.globalBindings, filePath, fileContent, this.globalBindings.isIncrementalDiscovering(), this.IS_FULL_LEVEL_ANALYSIS);
        parsedCompilationUnit.accept((ASTVisitor)jdtVisitor);
    }

    protected CompilationUnit parseCompilationUnit(ITypeRoot source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setResolveBindings(true);
        parser.setSource(source);
        CompilationUnit parsedCompilationUnit = (CompilationUnit)parser.createAST(null);
        return parsedCompilationUnit;
    }

    protected void resolveMethodRedefinition(Model resultModel) {
        MethodRedefinitionManager.resolveMethodRedefinitions(resultModel, this.factory);
    }

    protected void finalResolveBindings(Model resultModel) {
        this.globalBindings.resolveBindings(resultModel);
    }

    public static String getRelativePath(IProject aProject, CompilationUnit parsedCompilationUnit) {
        String filePathString;
        IPath filepath;
        IPath projectpath = aProject.getFullPath();
        if (projectpath.isPrefixOf(filepath = parsedCompilationUnit.getJavaElement().getPath())) {
            filepath = filepath.removeFirstSegments(projectpath.segmentCount());
        }
        if (!(filePathString = filepath.toOSString()).startsWith(File.separator)) {
            filePathString = String.valueOf(File.separator) + filePathString;
        }
        return filePathString;
    }

    public static StringBuilder getContent(IFile anIFile) throws CoreException, IOException {
        int read;
        InputStream is = anIFile.getContents();
        StringBuilder cuText = new StringBuilder();
        InputStreamReader r = new InputStreamReader(is);
        char[] chars = new char[100];
        while ((read = r.read(chars)) != -1) {
            if (read == 100) {
                cuText.append(chars);
                continue;
            }
            cuText.append(chars, 0, read);
        }
        is.close();
        return cuText;
    }

    protected void reset() {
        this.globalBindings.resolveBindings(this.resultModel);
        this.globalBindings = this.getBindingManager();
    }

    protected BindingManager getBindingManager() {
        BindingManager bindingManager = new BindingManager(this.factory);
        if (this.ISINCREMENTALDISCOVERING) {
            bindingManager.enableIncrementalDiscovering(this.resultModel);
        }
        return bindingManager;
    }

    @Override
    public void terminate(IProgressMonitor monitor) {
        monitor.subTask(Messages.JavaReader_bindingsTask);
        this.finalResolveBindings(this.resultModel);
        monitor.subTask(Messages.JavaReader_redefinitionsTask);
        this.resolveMethodRedefinition(this.resultModel);
    }
}

