/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.discoverersmanager.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.gmt.modisco.discoverersmanager.Discoverer;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoverersManager;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.discoverersmanager.handlers.DiscovererHandler;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.DiscovererUpdate;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.Messages;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.data.DiscoveryParameterDisplay;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.data.DiscoveryParameterDisplayImpl;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.parametersdisplay.DiscovererParametersComposite;
import org.eclipse.gmt.modisco.discoverersmanager.ui.launch.utils.ParameterUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DiscoverersMainTab
extends AbstractLaunchConfigurationTab
implements DiscovererUpdate {
    private Group sourceGroup = null;
    private Text sourceElementText = null;
    private Button sourceElementButton = null;
    private Group discovererKindGroup = null;
    private Group targetModelGroup = null;
    private Combo discovererKindCombo = null;
    private Label discoverKindLabel = null;
    private Composite rootContainer = null;
    private DiscovererParametersComposite parametersContainer = null;
    private final List<DiscoveryParameterDisplay> displayParameters = new ArrayList<DiscoveryParameterDisplay>();

    private final void createDiscovererParametersContainer() {
        this.parametersContainer = new DiscovererParametersComposite(this.rootContainer, 0);
    }

    private final void createSourceGroup() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.sourceGroup = new Group(this.rootContainer, 0);
        this.sourceGroup.setToolTipText(Messages.DiscoverersMainTab_0);
        this.sourceGroup.setLayout((Layout)gridLayout);
        this.sourceGroup.setLayoutData((Object)gridData);
        this.sourceGroup.setText(Messages.DiscoverersMainTab_1);
        this.sourceElementText = new Text((Composite)this.sourceGroup, 2048);
        this.sourceElementText.setLayoutData((Object)gridData2);
        this.sourceElementText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DiscoverersMainTab.this.update();
            }
        });
        this.sourceElementButton = new Button((Composite)this.sourceGroup, 0);
        this.sourceElementButton.setText(Messages.DiscoverersMainTab_2);
        this.sourceElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoverersMainTab.this.sourceBrowseEvent();
            }
        });
    }

    private final void createDiscovererKindGroup() {
        GridData gridData11 = new GridData();
        gridData11.horizontalAlignment = 4;
        gridData11.grabExcessHorizontalSpace = true;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        this.discovererKindGroup = new Group(this.rootContainer, 0);
        this.discovererKindGroup.setLayout((Layout)new GridLayout());
        this.discovererKindGroup.setLayoutData((Object)gridData11);
        this.discovererKindGroup.setText(Messages.DiscoverersMainTab_3);
        this.discoverKindLabel = new Label((Composite)this.discovererKindGroup, 0);
        this.discoverKindLabel.setText(Messages.DiscoverersMainTab_4);
        this.discovererKindCombo = new Combo((Composite)this.discovererKindGroup, 8);
        this.discovererKindCombo.setLayoutData((Object)gridData1);
        this.discovererKindCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiscoverersMainTab.this.updateDiscovererParametersContainer(null);
                DiscoverersMainTab.this.update();
            }
        });
    }

    protected final void updateDiscovererParametersContainer(ILaunchConfiguration configuration) {
        String kind = this.discovererKindCombo.getText();
        Discoverer discoverer = DiscoverersManager.getDefault().getDiscoverer(kind);
        this.displayParameters.clear();
        if (discoverer != null) {
            for (DiscoveryParameter parameter : discoverer.getDiscovererParameters()) {
                DiscoveryParameterDisplayImpl displayParameter = new DiscoveryParameterDisplayImpl(parameter, this);
                this.displayParameters.add(displayParameter);
                ParameterUtils.getInstance().updateParameterValue(displayParameter, configuration);
            }
            this.parametersContainer.updateDiscoveryParameters(this.displayParameters);
        } else {
            this.setErrorMessage(Messages.DiscoverersMainTab_5);
        }
    }

    private final void createTargetModelGroup() {
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        this.targetModelGroup = new Group(this.rootContainer, 0);
        this.targetModelGroup.setText(Messages.DiscoverersMainTab_6);
        this.targetModelGroup.setLayoutData((Object)gridData4);
        this.targetModelGroup.setLayout((Layout)gridLayout2);
    }

    public void createControl(Composite parent) {
        this.rootContainer = new Composite(parent, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.rootContainer.setLayout((Layout)gridLayout);
        this.rootContainer.setLayoutData((Object)gridData);
        this.createDiscovererKindGroup();
        this.createSourceGroup();
        this.createTargetModelGroup();
        this.createDiscovererParametersContainer();
        this.initializeDiscoverersKindList();
        this.setControl((Control)this.rootContainer);
    }

    private final void initializeDiscoverersKindList() {
        for (DiscovererHandler handler : DiscoverersManager.getDefault().getDiscovererHandlers()) {
            this.discovererKindCombo.add(handler.getName());
        }
    }

    public String getName() {
        return Messages.DiscoverersMainTab_7;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String sourcePath;
            String kind = configuration.getAttribute("discoverer_kind", "");
            if (kind.length() > 0) {
                this.discovererKindCombo.setText(kind);
            }
            if ((sourcePath = configuration.getAttribute("discoverer_source_path", "")).length() > 0) {
                this.sourceElementText.setText(sourcePath);
            }
            this.updateDiscovererParametersContainer(configuration);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.update();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String kind = this.discovererKindCombo.getText();
        if (kind.length() > 0) {
            configuration.setAttribute("discoverer_kind", kind);
            this.saveDisplayParameter(configuration);
        }
        String sourcePath = this.sourceElementText.getText();
        configuration.setAttribute("discoverer_source_path", sourcePath);
    }

    private final void saveDisplayParameter(ILaunchConfigurationWorkingCopy configuration) {
        for (DiscoveryParameterDisplay parameter : this.displayParameters) {
            ParameterUtils.getInstance().serializeParameterValue(parameter, configuration);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean result = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        try {
            String kind = launchConfig.getAttribute("discoverer_kind", "");
            String sourcePath = launchConfig.getAttribute("discoverer_source_path", "");
            if (kind.length() > 0) {
                Discoverer discoverer = DiscoverersManager.getDefault().getDiscoverer(kind);
                if (discoverer != null) {
                    result = this.validateSourcePath(sourcePath, discoverer);
                    if (result) {
                        result = this.validateDisplayParameters();
                    }
                } else {
                    result = false;
                    this.setErrorMessage(Messages.DiscoverersMainTab_12);
                }
            } else {
                result = false;
                this.setMessage(Messages.DiscoverersMainTab_13);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private final boolean validateDisplayParameters() {
        boolean result = true;
        for (DiscoveryParameterDisplay parameter : this.displayParameters) {
            if (!parameter.isRequired()) continue;
            boolean bl = result = result && parameter.getValue() != null;
        }
        if (!result) {
            this.setMessage(Messages.DiscoverersMainTab_14);
        }
        return result;
    }

    private final boolean validateSourcePath(String sourcePath, Discoverer discoverer) {
        boolean result;
        block12: {
            result = true;
            if (sourcePath.length() > 0) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IPath rootPath = root.getFullPath();
                if (rootPath.isValidPath(sourcePath)) {
                    IPath path = rootPath.append(sourcePath);
                    try {
                        IProject iproject = null;
                        String containerKind = "project";
                        if (path.segmentCount() == 1) {
                            iproject = root.getProject(sourcePath);
                        } else {
                            iproject = root.getFolder(path);
                            containerKind = "folder";
                        }
                        if (iproject != null && iproject.exists()) {
                            if (!discoverer.isApplicableTo(iproject)) {
                                result = false;
                                this.setErrorMessage(String.valueOf(Messages.DiscoverersMainTab_17) + containerKind);
                            }
                            break block12;
                        }
                        IFile ifile = root.getFile(path);
                        if (ifile != null && ifile.exists()) {
                            if (!discoverer.isApplicableTo(ifile)) {
                                result = false;
                                this.setErrorMessage(Messages.DiscoverersMainTab_18);
                            }
                            break block12;
                        }
                        result = false;
                        this.setErrorMessage(Messages.DiscoverersMainTab_19);
                    }
                    catch (IllegalArgumentException iae) {
                        result = false;
                        this.setErrorMessage(iae.getMessage());
                    }
                } else {
                    result = false;
                    this.setErrorMessage(Messages.DiscoverersMainTab_20);
                }
            } else {
                result = false;
                this.setMessage(Messages.DiscoverersMainTab_21);
            }
        }
        return result;
    }

    private final void sourceBrowseEvent() {
        String sourcePath = this.sourceElementText.getText();
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementTreeSelectionDialog.setMessage("Select a source element");
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setDoubleClickSelects(true);
        String kind = this.discovererKindCombo.getText();
        final Discoverer discoverer = DiscoverersManager.getDefault().getDiscoverer(kind);
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IStatus ret = Status.CANCEL_STATUS;
                if (selection.length == 1 && (discoverer == null || discoverer.isApplicableTo(selection[0]))) {
                    ret = Status.OK_STATUS;
                }
                return ret;
            }
        });
        elementTreeSelectionDialog.open();
        Object result = elementTreeSelectionDialog.getFirstResult();
        if (result != null && result instanceof IResource) {
            IResource currentFile = (IResource)result;
            sourcePath = currentFile.getFullPath().toString();
        }
        this.sourceElementText.setText(sourcePath);
        this.update();
    }

    public void update() {
        this.updateLaunchConfigurationDialog();
    }
}

