/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.facet.ui.views;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetPackage;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/**
 * @author gdupe
 * 
 */
public class FacetSetContentProvider implements ITreeContentProvider {

	private EClass deep;

	public FacetSetContentProvider(final EClass deep) {
		if (deep == null) {
			this.deep = FacetPackage.eINSTANCE.getFacetSet();
		} else {
			this.deep = deep;
		}
	}

	public Object[] getElements(final Object inputElement) {
		if (!(inputElement instanceof Object[])) {
			RuntimeException e;
			if (inputElement != null) {
				e = new RuntimeException("Unexpected inputElement type: " //$NON-NLS-1$
						+ inputElement.getClass().getName());
			} else {
				e = new RuntimeException("inputElement must not be null."); //$NON-NLS-1$
			}
			throw e;
		}
		return (Object[]) inputElement;
	}

	public void inputChanged(final Viewer viewer, final Object oldInput, final Object newInput) {
		// Nothing to do
	}

	public Object[] getChildren(final Object parentElement) {
		if (this.deep.isInstance(parentElement)) {
			return new Object[] {};
		} else if (parentElement instanceof FacetSet) {
			FacetSet facetSet = (FacetSet) parentElement;
			return facetSet.getFacets().toArray();
		} else if (parentElement instanceof Facet) {
			Facet facet = (Facet) parentElement;
			return facet.getEStructuralFeatures().toArray();
		} else {
			throw new RuntimeException("Unexpected inputElement type: " //$NON-NLS-1$
					+ parentElement.getClass().getName());
		}
	}

	public Object getParent(final Object element) {
		if (element instanceof EObject) {
			EObject eObject = (EObject) element;
			return eObject.eContainer();
		}
		throw new RuntimeException("Unexpected inputElement type: " //$NON-NLS-1$
				+ element.getClass().getName());
	}

	public boolean hasChildren(final Object element) {
		return !this.deep.isInstance(element);
	}

	public void dispose() {
		// Nothing to do
	}
}
