/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.query.core;

import java.util.HashMap;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmt.modisco.common.core.CommonModiscoActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends Plugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.eclipse.gmt.modisco.infra.query.core"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;

	private HashMap<String, Bundle> installedBundle = new HashMap<String, Bundle>();

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
	 */
	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		Activator.plugin = this;

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
	 */
	@Override
	public void stop(final BundleContext context) throws Exception {
		this.uninstallTmpBundles();
		ModelQuerySetCatalog.getSingleton().save();
		Activator.plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return Activator.plugin;
	}

	public void uninstallTmpBundles() {
		for (String uri : this.installedBundle.keySet()) {
			try {
				this.installedBundle.get(uri).uninstall();
			} catch (BundleException e) {
				IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
						e.getMessage(), e);
				Activator.getDefault().getLog().log(status);
			}
		}
	}

	public Bundle installBunble(final IProject project) {
		Bundle bundle = null;

		try {
			String projectUri = project.getLocation().toFile().toURI()
					.toString();
			if (this.installedBundle.containsKey(projectUri)) {
				this.installedBundle.get(projectUri).uninstall();
			} else {
				Bundle localBundle = Platform.getBundle(project.getName());
				if (localBundle != null) {
					localBundle.uninstall();
				}
			}
			bundle = Activator.getDefault().getBundle().getBundleContext()
					.installBundle(projectUri);
			this.installedBundle.put(projectUri, bundle);
			// bundle.start();
		} catch (Exception e) {
			IStatus status = new Status(IStatus.ERROR, Activator.PLUGIN_ID,
					"Failed to load bundle: " + project.getName(), e); //$NON-NLS-1$
			Activator.getDefault().getLog().log(status);
		}
		IStatus status = new Status(IStatus.INFO,
				CommonModiscoActivator.PLUGIN_ID, "Bundle load: " //$NON-NLS-1$
						+ project.getName());
		this.getLog().log(status);
		return bundle;
	}

}
