/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.infra.query.core.java;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;

/**
 * @author Grgoire Dup (Mia-Software)
 */
public interface IJavaModelQuery {

	/**
	 * This method must be overridden by each sub class to implement query
	 * evaluation.
	 * 
	 * @param context
	 *            The query evaluation context
	 * @param parameterValues
	 *            The query parameter values
	 * @return A list of ModelQueryResult (one per evaluation)
	 * @throws ModelQueryExecutionException
	 */
	public Object evaluate(final EObject context,
			final List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException;

}
