/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Fabien GIQUEL (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.java.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.m2m.atl.core.ATLCoreException;

public class DiscoverKdmModelFromJavaModel extends DefaultDiscoverer {

	private static List<DiscoveryParameter> parametersKeys = null;

	public Resource discoverElement(final Object source, final URI target) {
		Map<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
		parameters.put(PARAMETER_SILENT_MODE, false);
		discoverElement(source, parameters);
		return (Resource) parameters.get(PARAMETER_TARGET_RESOURCE);
	}

	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		// retrieval of Java project
		final IFile iFile = (IFile) source;
		final String sourcePath = iFile.getLocation().toString();
		Resource javaModelResource = new XMIResourceImpl();
		javaModelResource.setURI(URI.createFileURI(sourcePath));
		Resource kdmModelResource = null;

		try {

			URI javaModelURI = javaModelResource.getURI();
			URI kdmModelUri = javaModelURI
			.trimFileExtension()
			.appendFileExtension(
					DiscoverKdmModelFromJavaProject.KDM_FILE_EXTENSION);
			TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
			kdmModelResource = kdmTranslater
			.getKDMModelFromJavaModelWithCustomTransformation(
					javaModelURI, kdmModelUri);

			if (kdmModelResource != null) {
				// schedule editor opening
				String kdmFileString = kdmModelUri.toFileString();
				IFile kdmFile = ResourcesPlugin.getWorkspace().getRoot()
				.getFileForLocation(new Path(kdmFileString));

				// refresh the folder
				kdmFile.getProject().refreshLocal(IResource.DEPTH_ONE,
						new NullProgressMonitor());

				// browse result model
				this.openEditor(kdmFile, parameters);

				// set output parameter
				parameters.put(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE,
						kdmModelResource);
			}
		} catch (IOException e) {
			MoDiscoLogger.logError(e, JavaActivator.getDefault());
		} catch (ATLCoreException e) {
			MoDiscoLogger.logError(e, JavaActivator.getDefault());
		} catch (CoreException e) {
			MoDiscoLogger.logError(e, JavaActivator.getDefault());
		}

	}

	public List<DiscoveryParameter> getDiscovererParameters() {
		if (DiscoverKdmModelFromJavaModel.parametersKeys == null) {
			DiscoverKdmModelFromJavaModel.parametersKeys = new ArrayList<DiscoveryParameter>();
			DiscoverKdmModelFromJavaModel.parametersKeys
					.add(PARAMETER_SILENT_MODE);
			DiscoverKdmModelFromJavaModel.parametersKeys
					.add(PARAMETER_TARGET_RESOURCE);
		}
		return DiscoverKdmModelFromJavaModel.parametersKeys;
	}

	public boolean isApplicableTo(final Object source) {
		boolean result = false;
		if (source instanceof IFile) {
			IFile iFile = (IFile) source;
			String extension = iFile.getFileExtension();
			result = (extension != null)
					&& (extension.equals(DefaultDiscoverer.JAVA_FILE_EXTENSION));
		}
		return result;
	}

	public String toString() {
		return Messages.DiscoverKdmModelFromJavaModel_title;
	}

}
