/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Fabien Giquel (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Erwan Breton (Sodifrance) - initial API and implementation
 *    Romain Dervaux (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.java;

import java.io.PrintStream;

public final class TimeResults {
	
	private static final int NANO = 1000000000;
	private static final int MILLI = 1000;
	public static long javaProjectASTParserCreation = 0;
	public static long javaProjectParse = 0;
	
	public static long librariesParse = 0;
	
	public static long resolveBindings = 0;
	public static long resolveMethodRedefinitions = 0;
	public static long modelSave = 0;
	
	private TimeResults() {
	}

	public static void printTimes(final PrintStream out) {
		out
				.println("JavaProject_ASTParserCreation : " + millisToSeconds(TimeResults.javaProjectASTParserCreation) + " s"); //$NON-NLS-1$ //$NON-NLS-2$
		out
				.println("JavaProject_parse : " + millisToSeconds(TimeResults.javaProjectParse) + " s"); //$NON-NLS-1$ //$NON-NLS-2$
		
		out
				.println("Libraries_parse : " + millisToSeconds(TimeResults.librariesParse) + " s"); //$NON-NLS-1$ //$NON-NLS-2$
		
		out
				.println("resolveBindings : " + millisToSeconds(TimeResults.resolveBindings) + " s"); //$NON-NLS-1$ //$NON-NLS-2$
		out
				.println("resolveMethodRedefinitions : " + millisToSeconds(TimeResults.resolveMethodRedefinitions) + " s"); //$NON-NLS-1$ //$NON-NLS-2$
		
		out
				.println("modelSave : " + millisToSeconds(TimeResults.modelSave) + " s"); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	public static long millisToSeconds(final long t) {
		return t / TimeResults.MILLI;
	}
	
	public static long nanosToSeconds(final long t) {
		return t / TimeResults.NANO;
	}
	
	public static void reset() {
		TimeResults.javaProjectASTParserCreation = 0;
		TimeResults.javaProjectParse = 0;
		TimeResults.librariesParse = 0;
		TimeResults.resolveBindings = 0;
		TimeResults.resolveMethodRedefinitions = 0;
		TimeResults.modelSave = 0;
	}
}
