/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.facet.Facet;
import org.eclipse.gmt.modisco.infra.facet.FacetSet;
import org.eclipse.gmt.modisco.infra.facet.core.FacetContext;
import org.eclipse.gmt.modisco.infra.facet.core.FacetSetCatalog;
import org.eclipse.gmt.modisco.infra.facet.core.exception.ModiscoFacetException;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryException;

public class Example {

	public Integer getNbAbstractMethod(EObject eObject)
			throws ModelQueryException, ModiscoFacetException {
		FacetSet facetSet = FacetSetCatalog.getSingleton().getFacetSet(Messages.Example_0);
		FacetContext context = new FacetContext();
		context.addFacetSet(facetSet);
		Facet facet = facetSet.getFacet("AbstractClassDeclaration"); //$NON-NLS-1$
		if (context.isInstance(eObject, facet)) {
			Object object = context.get(eObject, facet
					.getEStructuralFeature("nbAbstractMethod")); //$NON-NLS-1$
			if (object instanceof Integer) {
				Integer nbAbstractMethod = (Integer) object;
				return nbAbstractMethod;
			}
		}
		return null;
	}
}
