/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.browser.Messages;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.core.ModelElementItem;
import org.eclipse.gmt.modisco.infra.query.ui.views.queryExecution.QueryExecutionView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/**
 * Opens the "Query Execution" view, and sets its context to the list of
 * currently selected {@link EObject}s in the browser.
 */
public class ExecuteQueryAction extends Action {

	private final IBrowserActionBarContributor browserActionBarContributor;

	public ExecuteQueryAction(final IBrowserActionBarContributor browserActionBarContributor) {
		super(Messages.ExecuteQueryAction_executeQuery);
		this.browserActionBarContributor = browserActionBarContributor;
	}

	@Override
	public void run() {
		ISelection selection = this.browserActionBarContributor.getSelection();
		List<EObject> selectedEObjects = new ArrayList<EObject>();
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			Iterator<?> iterator = structuredSelection.iterator();
			while (iterator.hasNext()) {
				Object selectedElement = iterator.next();
				if (selectedElement instanceof ModelElementItem) {
					ModelElementItem element = (ModelElementItem) selectedElement;
					selectedEObjects.add(element.getEObject());
				}
			}
		}

		IViewPart view = openQueryExecutionView();
		if (selectedEObjects.size() > 0) {
			if (view instanceof QueryExecutionView) {
				QueryExecutionView queryExecutionView = (QueryExecutionView) view;
				queryExecutionView.setContext(selectedEObjects);
			}
		}
	}

	private IViewPart openQueryExecutionView() {
		try {
			IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
			if (window != null) {
				IWorkbenchPage activePage = window.getActivePage();
				if (activePage != null) {
					return activePage.showView(QueryExecutionView.ID);
				}
			}
		} catch (final PartInitException e) {
			MoDiscoBrowserPlugin.logException(e);
		}
		return null;
	}
}
