/*******************************************************************************
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.adapters;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.gmt.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.gmt.modisco.infra.facet.FacetStructuralFeature;
import org.eclipse.gmt.modisco.infra.facet.Shortcut;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class PropertySourceAdapter extends AdapterImpl implements IPropertySource {

	private final BrowserConfiguration fBrowserConfiguration;

	public PropertySourceAdapter(final Notifier target,
			final BrowserConfiguration browserConfiguration) {
		this.fBrowserConfiguration = browserConfiguration;
		setTarget(target);
	}

	@Override
	public boolean isAdapterForType(final Object type) {
		return (type == IPropertySource.class);
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		final List<IPropertyDescriptor> propertyDescriptors = new ArrayList<IPropertyDescriptor>();
		final EObject eObject = (EObject) getTarget();

		final List<EAttribute> eAllAttributes = new ArrayList<EAttribute>(eObject.eClass()
				.getEAllAttributes());

		// Collections.sort(eAllAttributes, new Comparator<EAttribute>() {
		// public int compare(EAttribute a1, EAttribute a2) {
		// return a1.getName().compareTo(a2.getName());
		// }
		// });

		for (final EAttribute eAttribute : eAllAttributes) {
			final String name;
			if (eAttribute.isDerived()) {
				name = "/" + eAttribute.getName(); //$NON-NLS-1$
			} else {
				name = eAttribute.getName();
			}
			propertyDescriptors.add(new PropertyDescriptor(eAttribute, name));
		}

		final List<EStructuralFeature> facetFeatures = this.fBrowserConfiguration.getFacetContext()
				.getFacetFeatures(eObject);
		for (final EStructuralFeature feature : facetFeatures) {
			if (feature instanceof EAttribute) {
				final EAttribute facetAttribute = (EAttribute) feature;
				propertyDescriptors.add(new PropertyDescriptor(facetAttribute, "/" //$NON-NLS-1$
						+ facetAttribute.getName()));
			}

		}

		return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
	}

	public Object getPropertyValue(final Object id) {
		if (id instanceof EAttribute) {
			final EAttribute eAttribute = (EAttribute) id;
			final Object value = localEGet(eAttribute);
			if (!eAttribute.isMany()) {
				if (value != null) {
					return value.toString();
				} else {
					return ""; //$NON-NLS-1$
				}
			} else {
				final StringBuilder builder = new StringBuilder();
				@SuppressWarnings("unchecked")
				final List<Object> list = (List<Object>) value;
				for (int i = 0; i < list.size(); i++) {
					final Object object = list.get(i);
					builder.append(object.toString());
					if (i != list.size() - 1) {
						builder.append(", "); //$NON-NLS-1$
					}
				}
				// ModelElementItem modelElementItem = new
				// ModelElementItem(eObject, null,
				// browserConfiguration);
				// String text = modelElementItem.getText();

				return builder.toString();
			}
		}
		return null;
	}

	private Object localEGet(final EStructuralFeature structuralFeature) {
		final EObject eObject = (EObject) getTarget();
		Object result;
		if (structuralFeature instanceof FacetStructuralFeature
				|| structuralFeature instanceof Shortcut) {
			try {
				result = this.fBrowserConfiguration.getFacetContext()
						.get(eObject, structuralFeature);
			} catch (final Exception e) {
				MoDiscoBrowserPlugin.logException(e);
				result = null;
			}
		} else {
			result = eObject.eGet(structuralFeature);
		}
		return result;
	}

	public Object getEditableValue() {
		return null;
	}

	public boolean isPropertySet(final Object id) {
		// if (id instanceof EAttribute) {
		// EAttribute eAttribute = (EAttribute) id;
		// return eObject.eGet(eAttribute) == null;
		// }
		return false;
	}

	public void resetPropertyValue(final Object id) {
	}

	public void setPropertyValue(final Object id, final Object value) {
	}
}
