/*******************************************************************************
 * Copyright (c) 2008, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.editors;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmt.modisco.common.core.utils.UriUtils;
import org.eclipse.gmt.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.swt.widgets.Display;

/**
 * Listens to workspace changes to detect changed resources and update the
 * browser accordingly
 */
public class WorkspaceChangeListener implements IResourceChangeListener {

	private final EcoreBrowser fBrowser;

	public WorkspaceChangeListener(final EcoreBrowser browser) {
		this.fBrowser = browser;
	}

	public void resourceChanged(final IResourceChangeEvent event) {
		final IResourceDelta eventDelta = event.getDelta();
		try {
			class ResourceDeltaVisitor implements IResourceDeltaVisitor {
				private final ResourceSet resourceSet = WorkspaceChangeListener.this.fBrowser
						.getResourceSet();

				public boolean visit(final IResourceDelta delta) {
					if (delta.getResource().getType() == IResource.FILE) {
						if (delta.getKind() == IResourceDelta.REMOVED
								|| delta.getKind() == IResourceDelta.CHANGED
								&& delta.getFlags() != IResourceDelta.MARKERS) {

							final Resource resource = this.resourceSet.getResource(UriUtils
									.createUri(delta.getFullPath().toString()), false);
							if (resource != null) {
								Display.getDefault().asyncExec(new Runnable() {
									public void run() {
										if (delta.getKind() == IResourceDelta.REMOVED) {
											// close editor when model file is
											// deleted
											EcoreBrowser browser = WorkspaceChangeListener.this.fBrowser;
											browser.getSite().getPage().closeEditor(browser, false);
											return;
										}
										// reload model in editor when changed
										WorkspaceChangeListener.this.fBrowser.reloadModel();
									}
								});
								return false;
							}
						}
					}
					return true;
				}
			}

			final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
			eventDelta.accept(visitor);

		} catch (final CoreException exception) {
			MoDiscoBrowserPlugin.logException(exception);
		}
	}
}
