/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - initial API and implementation
 *    
 *******************************************************************************/

package org.eclipse.gmt.modisco.infra.browser.custom.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public final class CustomizationsRegistry {

	private static final String REGISTRATION_EXTENSION_POINT_ID = "org.eclipse.gmt.modisco.infra.browser.custom.core.registration"; //$NON-NLS-1$

	private static CustomizationsRegistry instance = null;

	private final List<URL> uiCustomURLS = new ArrayList<URL>();
	private final List<URL> uiCustomDefaultURLS = new ArrayList<URL>();

	private CustomizationsRegistry() {
		readExtensions();
	}

	public static CustomizationsRegistry getInstance() {
		if (CustomizationsRegistry.instance == null) {
			CustomizationsRegistry.instance = new CustomizationsRegistry();
		}
		return CustomizationsRegistry.instance;
	}

	public List<URL> getUiCustomURLS() {
		return this.uiCustomURLS;
	}

	private void readExtensions() {
		try {
			final IConfigurationElement[] configurationElements = Platform.getExtensionRegistry()
					.getConfigurationElementsFor(
							CustomizationsRegistry.REGISTRATION_EXTENSION_POINT_ID);

			for (final IConfigurationElement configurationElement : configurationElements) {
				final String fileAttribute = configurationElement.getAttribute("file"); //$NON-NLS-1$
				if (fileAttribute == null) {
					Activator
							.logError("Missing 'file' attribute in customization registration extension"); //$NON-NLS-1$
					continue;
				}

				final String pluginId = configurationElement.getNamespaceIdentifier();
				final Bundle bundle = Platform.getBundle(pluginId);
				final URL url = FileLocator.find(bundle, new Path(fileAttribute), null);
				this.uiCustomURLS.add(url);
				String loadByDefaultAttribute = configurationElement.getAttribute("loadByDefault");
				if (loadByDefaultAttribute != null
						&& loadByDefaultAttribute.equalsIgnoreCase(String.valueOf(Boolean.TRUE))) {
					this.uiCustomDefaultURLS.add(url);
				}
			}
		} catch (final Exception e) {
			Activator.logException(e);
		}
	}

	public List<URL> getUiCustomDefaultURLS() {
		return this.uiCustomDefaultURLS;
	}

}
