/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.query.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.query.JavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ui.Messages;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ClassAlreadyExistsException;
import org.eclipse.gmt.modisco.infra.query.ui.exceptions.ResourceURIExpectedException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.Wizard;

public class NewClassCreationWizard extends Wizard {

	private final JavaModelQuery query;
	private final IJavaProject javaProject;
	private NewQueryClassWizardPage mainPage;

	public NewClassCreationWizard(final JavaModelQuery query) throws ResourceURIExpectedException,
			JavaModelException, ClassAlreadyExistsException {
		Resource resource = query.eResource();
		URI uri = resource.getURI();
		if (!uri.isPlatformResource()) {
			throw new ResourceURIExpectedException();
		}
		String projectName = uri.segment(1);
		IWorkspace ws = ResourcesPlugin.getWorkspace();
		IProject project = ws.getRoot().getProject(projectName);
		this.javaProject = JavaCore.create(project);
		this.query = query;
		if (this.javaProject.findType(this.query.getImplementationClassName()) != null) {
			throw new ClassAlreadyExistsException();
		}

	}

	@Override
	public void addPages() {
		this.mainPage = new NewQueryClassWizardPage(this.javaProject, this.query
				.getImplementationClassName());
		addPage(this.mainPage);
		this.mainPage.init(null);
	}

	@Override
	public boolean performFinish() {
		try {
			this.mainPage.createType(new NullProgressMonitor());
		} catch (Exception e) {
			MessageDialog.openError(this.getShell(), Messages.NewClassCreationWizard_0,
					Messages.NewClassCreationWizard_1);
		}
		return true;
	}
}
