/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.query.ui.wizards;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.resources.IFolder;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.ui.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;

public class NewQueryClassWizardPage extends NewClassWizardPage {

	final IJavaProject project;
	protected String qname;

	public NewQueryClassWizardPage(final IJavaProject project, final String name) {
		this.project = project;
		this.qname = name;
	}

	@Override
	public void init(final IStructuredSelection selection) {
		List<String> interfaceList = new ArrayList<String>();
		interfaceList.add(IJavaModelQuery.class.getName());
		setSuperInterfaces(interfaceList, false);
		String name = this.qname.substring(this.qname.lastIndexOf('.') + 1);
		setTypeName(name, false);
		String packageName = this.qname.substring(0, this.qname.lastIndexOf('.'));
		IFolder packageFolder = this.project.getProject().getFolder(packageName);
		IPackageFragmentRoot packageFragmentRoot = null;
		try {
			for (IPackageFragmentRoot packageFragmentRootToTest : this.project
					.getPackageFragmentRoots()) {
				if (packageFragmentRootToTest.getKind() == IPackageFragmentRoot.K_SOURCE) {
					packageFragmentRoot = packageFragmentRootToTest;
					setPackageFragmentRoot(packageFragmentRoot, false);
					IPackageFragment packageFragment = packageFragmentRoot
							.getPackageFragment(packageFolder.getProjectRelativePath().toOSString());
					setPackageFragment(packageFragment, false);
					break;
				}
			}
		} catch (JavaModelException e1) {
			MoDiscoLogger.logError(e1, Activator.getDefault());
		}
		setMethodStubSelection(false, false, true, false);
		setModifiers(this.F_PUBLIC, false);
		setSuperClass("", false); //$NON-NLS-1$
		setEnclosingTypeSelection(false, false);
	}

	@Override
	public IJavaProject getJavaProject() {
		return this.project;
	}

}
