/*******************************************************************************
 * Copyright (c) 2008, 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *    Nicolas Bros (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.common.core.utils;

import org.eclipse.gmt.modisco.common.core.Messages;


/**
 * @author Gabriel Barbier
 * 
 */
public final class StringUtils {
	public static final String ELLIPSIS = Messages.StringUtils_ellipsis;
	private static final int TRUNCATE_AFTER = 100;

	private StringUtils() {
		// prevent instantiation
	}

	public static String firstLetterToLowerCase(final String source) {
		String result;
		if (source.length() == 0) {
			result = source;
		} else if (source.length() == 1) {
			result = source.toLowerCase();
		} else {
			result = source.substring(0, 1).toLowerCase() + source.substring(1);
		}
		return result;
	}

	public static String firstLetterToUpperCase(final String source) {
		String result;
		if (source.length() == 0) {
			result = source;
		} else if (source.length() == 1) {
			result = source.toUpperCase();
		} else {
			result = source.substring(0, 1).toUpperCase() + source.substring(1);
		}
		return result;
	}

	/**
	 * Truncate the given String before the first newline or a maximum number of
	 * characters, whichever comes first. Ends the string by an ellipsis ("...")
	 * if it was effectively truncated.
	 * 
	 * @param str
	 *            the string to truncate
	 * @return the part of the given string before the first newline
	 */
	public static String truncateBeforeNewline(final String str) {
		int index = str.indexOf('\r');
		if (index == -1) {
			index = str.indexOf('\n');
		}

		if (index != -1 && index > StringUtils.TRUNCATE_AFTER || index == -1
				&& str.length() > StringUtils.TRUNCATE_AFTER) {
			index = StringUtils.TRUNCATE_AFTER;
		}

		if (index != -1) {
			return str.substring(0, index) + StringUtils.ELLIPSIS;
		}
		return str;
	}
}
