/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.actions;

import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerDriverPage;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.ui.DriversWizard;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

/**
 * The aim of this class is to launch wizard driver
 * This wizard is called to create, edit or load a MoDiscoWork
 * @author Nicolas Payneau
 */
public class LaunchDriversWizard {

	private ControllerWorkflowTransformation controllerWorkflow;
	private ControllerDriverPage controllerDriverPage;
	private DriversWizard wizard;

	/**
	 * Class constructor
	 * @param controller The controller managing the workflow
	 * @param controllerDriverPage The controller managing the display
	 */
	public LaunchDriversWizard(ControllerWorkflowTransformation controller,
			ControllerDriverPage controllerDriverPage) {
		this.controllerWorkflow = controller;
		this.controllerDriverPage = controllerDriverPage;
	}
	
	/**
	 * Configure and open the wizard
	 * @param action
	 * @param mode Opening mode of wizard
	 */
	@SuppressWarnings("static-access")
	public void run(IAction action, Constants mode) {
		Image oldImage = Window.getDefaultImage();
		this.wizard = new DriversWizard(this.controllerWorkflow,
				this.controllerDriverPage, mode);
		// Create the wizard dialog
		WizardDialog dialog = new WizardDialog(PlatformUI.createDisplay().getActiveShell(),this.wizard);
		// Open the wizard dialog
		dialog.setPageSize(400, 200);
		dialog.setDefaultImage(Activator.getImageDescriptor(
				Constants.pathLittleImage).createImage());
		dialog.open();
		// restore default icon
		Window.setDefaultImage(oldImage);
	}
}
