/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.swt.widgets.Composite;

/**
 * Allows to go round some method of LaunchConfigurationTabGroupViewer
 * @author Nicolas Payneau
 */
@SuppressWarnings("restriction")
public class MoDiscoWorkLaunchConfigurationTabGroupViewer extends
		LaunchConfigurationTabGroupViewer {

	/**
	 * Class constructor
	 */
	public MoDiscoWorkLaunchConfigurationTabGroupViewer(Composite parent,
			ILaunchConfigurationDialog dialog) {
		super(parent, dialog);
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer#getWorkingCopy()
	 */
	@Override
	public ILaunchConfigurationWorkingCopy getWorkingCopy() {
		return super.getWorkingCopy();
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupViewer#handleApplyPressed()
	 */
	@Override
	public boolean handleApplyPressed() {
		return super.handleApplyPressed();
	}

	@Override
	protected void verifyName() throws CoreException {
		try{	
			super.verifyName();
			((MoDiscoWorkLaunchConfigurationDialog)getLaunchConfigurationDialog()).setPageComplete(true);
		}catch(CoreException e){
			((MoDiscoWorkLaunchConfigurationDialog)getLaunchConfigurationDialog()).setPageComplete(false);
			throw e;
		}
	}
}
