/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire Dupe (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.discoverer.tests.cdo;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.logging.MoDiscoLogger;
import org.eclipse.gmt.modisco.discoverersmanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.discoverer.tests.Activator;
import org.eclipse.gmt.modisco.java.discoverer.tests.JavaJUnitEMF;
import org.eclipse.gmt.modisco.java.discoverer.tests.Server;
import org.eclipse.gmt.modisco.java.discoverer.tests.cdo.client.JavaDiscovererCDO;
import org.eclipse.gmt.modisco.java.discoverer.tests.cdo.server.AbstractCDOServer;
import org.eclipse.gmt.modisco.java.discoverer.tests.cdo.server.DerbyCDOServer;
import org.eclipse.jdt.core.IJavaProject;

public class JavaJunitCDO extends JavaJUnitEMF {

	private int port = 2036;
	private static Server server;

	@Override
	protected void getResource(final IJavaProject javaProject) {
		try {
			if (JavaJunitCDO.server == null) {
				JavaJunitCDO.server = new DerbyCDOServer();
				JavaJunitCDO.server.start("db" + System.currentTimeMillis(), //$NON-NLS-1$
						this.port);
			}
			// ILaunch iLaunch = launch(serverClass.getSimpleName(), port);
			Thread.sleep(AbstractCDOServer.SLEEP_TIME_AFTER_LAUNCHE);
			IStatus status2 = new Status(IStatus.INFO, Activator.PLUGIN_ID,
					"Starting discovery"); //$NON-NLS-1$
			Activator.getDefault().getLog().log(status2);
			JavaDiscovererCDO discoverer = new JavaDiscovererCDO() {
				@Override
				protected void terminate(final Resource r) {
					// Nothing to do to let the session opened
				}
			};
			discoverer.setPort(this.port);
			Map<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
			parameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, true);
			discoverer.discoverElement(javaProject, parameters);

			resource = (Resource) parameters
					.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
		} catch (Exception e) {
			MoDiscoLogger.logError(e, Activator.getDefault());
		}
	}
}
