/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *    Romain Dervaux (Mia-Software)
 *******************************************************************************/

package org.eclipse.gmt.modisco.java.discoverer.tests.emfstat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.java.JavaActivator;
import org.eclipse.gmt.modisco.java.discoverer.tests.Activator;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;

public class Statistics {// implements JavaDiscovererListener{
	private static final long GC_SLEEP = 50;
	// private static final String MAX_FREE_MEMORY = "MAX_FREE_MEMORY";
	// private static final String MIN_FREE_MEMORY = "MIN_FREE_MEMORY";
	private static final String FREE_MEMORY = "FREE_MEMORY (Mo)"; //$NON-NLS-1$
	public static final String MAX_TOTAL_MEMORY = "MAX_TOTAL_MEMORY"; //$NON-NLS-1$
	// private static final String MIN_TOTAL_MEMORY = "MIN_TOTAL_MEMORY";
	private static final String MAX_PENDING_SIZE = "MAX_PENDING_SIZE"; //$NON-NLS-1$
	// private static final String MIN_PENDING_SIZE = "MIN_PENDING_SIZE";
	private static final String NB_COMPILATION_UNITS = "NB_COMPILATION_UNITS"; //$NON-NLS-1$
	private static final String CURRENT_PENDING_SIZE = "CURRENT_PENDING_SIZE"; //$NON-NLS-1$
	private static final String NB_LINES = "NB_LINES"; //$NON-NLS-1$
	private static final String MAX_TARGET_SIZE = "NB_LINES"; //$NON-NLS-1$
	// private static final String MIN_TARGET_SIZE = "MIN_TARGET_SIZE";
	private static final String CURRENT_TARGET_SIZE = "CURRENT_TARGET_SIZE"; //$NON-NLS-1$
	public static final String SINCEBEGIN = "SINCEBEGIN (ms)"; //$NON-NLS-1$
	private static final String DEBUG = "DEBUG"; //$NON-NLS-1$
	private static final String NB_ELEMENTS = "NB_ELEMENT"; //$NON-NLS-1$
	public static final String SAVE = "SAVE (ms)"; //$NON-NLS-1$
	private static final String TOTAL_RESOLVE = "TOTAL_RESOLVE"; //$NON-NLS-1$
	private static final String DISCOVERY = "DISCOVERY"; //$NON-NLS-1$
	private static final String FINAL_RESOLVE = "FINAL_RESOLVE"; //$NON-NLS-1$
	public static final String USED_MEMORY = "USED_MEMORY"; //$NON-NLS-1$
	public static final String DEBUG_CODE = "DEBUG_CODE"; //$NON-NLS-1$
	private static final String EXEC_DURATION = "EXEC_DURATION"; //$NON-NLS-1$
	private long nbOfReadPackageFragmentCounters = 0;
	private int nbOfReadCompilationUnits = 0;
	private long nbOfReadLines = 0;
	// private CDOTransaction transaction;
	private long beginSave = 0;
	private long beginFinalResolve = 0;
	private long beginResolve;
	private String statisticId;
	private PrintStream ps;
	private HashMap<String, Integer> messageMap = new HashMap<String, Integer>();
	private Long end = null;
	private Long beginDiscovery = null;
	private Long begin = null;
	File statisticsDir;
	private PrintStream txtPrintStream;
	private static Statistics singleton;
	private static HashMap<String, Statistics> instanceMap = new HashMap<String, Statistics>();
	private static HashMap<String, Object> statisticMap = new HashMap<String, Object>();
	private long beginInit = 0;
	private File txtFile;
	public static final String INIT_TIME = "INIT_TIME"; //$NON-NLS-1$
	public static final String TSV_FILE_EXT = "tsv"; //$NON-NLS-1$
	public static final String PROPERTIES_FILE_EXT = "txt"; //$NON-NLS-1$

	public Statistics(String id) {
		this.statisticId = id;
		String javaIoTmpdirStr = System.getProperty("java.io.tmpdir"); //$NON-NLS-1$
		File javaIoTmpdir = new File(javaIoTmpdirStr);
		this.statisticsDir = new File(javaIoTmpdir, "statistics"); //$NON-NLS-1$
		this.statisticsDir.mkdirs();
		initPrinitStream();
	}

	public Statistics(String id, File directory) {
		this.statisticId = id;
		directory.mkdirs();
		this.statisticsDir = directory;
		initPrinitStream();
	}

	private void initPrinitStream() {
		File tsvFile = new File(this.statisticsDir, this.statisticId
				+ "." + TSV_FILE_EXT); //$NON-NLS-1$
		txtFile = new File(this.statisticsDir, this.statisticId
				+ "." + PROPERTIES_FILE_EXT); //$NON-NLS-1$
		Status status = new Status(IStatus.INFO, JavaActivator.PLUGIN_ID,
				"TSV statistic file= " + tsvFile.toString()); //$NON-NLS-1$
		Activator.getDefault().getLog().log(status);
		Status status2 = new Status(IStatus.INFO, JavaActivator.PLUGIN_ID,
				"TXT statistic file= " + txtFile.toString()); //$NON-NLS-1$
		Activator.getDefault().getLog().log(status2);
		try {
			this.ps = new PrintStream(tsvFile);
			this.txtPrintStream = new PrintStream(txtFile);
		} catch (FileNotFoundException e) {
			Status status3 = new Status(IStatus.ERROR, JavaActivator.PLUGIN_ID,
					e.getMessage(), e);
			Activator.getDefault().getLog().log(status3);
		}
	}

	public static Statistics getStatistics(String key) {
		if (instanceMap.containsKey(key)) {
			return instanceMap.get(key);
		} else {
			Statistics statistics = new Statistics(key);
			instanceMap.put(key, statistics);
			return statistics;
		}
	}

	public static Statistics getStatistics(String key, File directory) {
		if (instanceMap.containsKey(key)) {
			return instanceMap.get(key);
		} else {
			Statistics statistics = new Statistics(key, directory);
			instanceMap.put(key, statistics);
			return statistics;
		}
	}

	public void reset() {
		// statisticMap.put(MAX_FREE_MEMORY, new Long(0));
		// statisticMap.put(MIN_FREE_MEMORY, Long.MAX_VALUE);
		statisticMap.put(FREE_MEMORY, new Long(0));
		statisticMap.put(MAX_TOTAL_MEMORY, new Long(0));
		// statisticMap.put(MIN_TOTAL_MEMORY, Long.MAX_VALUE);
		// statisticMap.put(MIN_PENDING_SIZE, Long.MAX_VALUE);
		statisticMap.put(MAX_PENDING_SIZE, new Long(0));
		statisticMap.put(CURRENT_PENDING_SIZE, new Long(0));
		statisticMap.put(NB_COMPILATION_UNITS, new Long(0));
		statisticMap.put(NB_LINES, new Long(0));
		statisticMap.put(MAX_TARGET_SIZE, new Long(0));
		// statisticMap.put(MIN_TARGET_SIZE, Long.MAX_VALUE);
		statisticMap.put(CURRENT_TARGET_SIZE, new Long(0));
		statisticMap.put(SAVE, new Long(0));
		statisticMap.put(EXEC_DURATION, new Long(0));
		statisticMap.put(TOTAL_RESOLVE, new Long(0));
		statisticMap.put(USED_MEMORY, new Long(0));
		statisticMap.put(DEBUG_CODE, new Long(0));
		statisticMap.put(DISCOVERY, new Long(0));
		statisticMap.put(FINAL_RESOLVE, new Long(0));
		statisticMap.put(NB_ELEMENTS, new Long(0));
		statisticMap.put(DEEP_REMOVE, new Long(0));
		statisticMap.put(MESSAGE, ""); //$NON-NLS-1$
		this.nbOfReadPackageFragmentCounters = 0;
		this.nbOfReadCompilationUnits = 0;
		this.nbOfReadLines = 0;
		this.beginSave = 0;
		this.beginFinalResolve = 0;
		this.beginResolve = 0;
		this.begin = null;
		this.end = null;
		this.beginDiscovery = null;

		new Thread() {
			@Override
			public void run() {
				try {
					String[] cmd = new String[] { "explorer", //$NON-NLS-1$
							Statistics.this.statisticsDir.toString() };
					Runtime.getRuntime().exec(cmd);
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		};// .start();

	}

	private void recordMemory() {
		Runtime.getRuntime().gc();
		try {
			Thread.sleep(GC_SLEEP);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		long freememory = Runtime.getRuntime().freeMemory() / 1024 / 1024;
		statisticMap.put(FREE_MEMORY, freememory);
		long totalmemory = Runtime.getRuntime().totalMemory() / 1024 / 1024;
		Long maxtotalmemory = (Long) statisticMap.get(MAX_TOTAL_MEMORY);
		maxtotalmemory = Math.max(maxtotalmemory == null ? 0 : maxtotalmemory,
				totalmemory);
		statisticMap.put(MAX_TOTAL_MEMORY, maxtotalmemory);
		statisticMap.put(USED_MEMORY, totalmemory - freememory);
	}

	public void recordPendingSize(List<Object> list) {
		long currentPendingSize = list.size();
		long maxPendingSize = (Long) statisticMap.get(MAX_PENDING_SIZE);
		statisticMap.put(MAX_PENDING_SIZE, Math.max(maxPendingSize,
				currentPendingSize));
		statisticMap.put(CURRENT_PENDING_SIZE, currentPendingSize);
	}

	public void recordTargetSize(Map<Object, Object> map) {
		Long currentTargetSize = new Long(map.size());
		Long maxTargetSize = (Long) statisticMap.get(MAX_TARGET_SIZE);
		statisticMap.put(MAX_TARGET_SIZE, Math.max(maxTargetSize,
				currentTargetSize));
		statisticMap.put(CURRENT_TARGET_SIZE, currentTargetSize);
	}

	public String tabKeyReport() {
		this.recordMemory();
		this.sinceBegin();
		this.debug(""); //$NON-NLS-1$
		StringBuffer sbKey = new StringBuffer();
		Iterator<String> it = statisticMap.keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			sbKey.append(key + "\t"); //$NON-NLS-1$
		}
		String result = sbKey.toString();
		this.ps.println(result);
		return result;
	}

	public String tabValueReport(String message) {
		debug(message);
		return tabValueReport();
	}

	public void sinceBegin() {
		Long result;
		if (this.begin != null) {
			if (this.end != null) {
				result = this.end - this.begin;
			} else {
				result = new Date().getTime() - this.begin;
			}
		} else {
			result = new Long(-1000);
		}
		statisticMap.put(SINCEBEGIN, result);
	}

	// public PrintStream getPS() {
	// return this.txtPrintStream;
	// }

	public void printProperty(String key, String value) {
		this.txtPrintStream.println(key + "=" + value); //$NON-NLS-1$
	}

	public void debug(String message) {
		int debugCode;
		if (this.messageMap.containsKey(message)) {
			debugCode = this.messageMap.get(message);
		} else {
			int size = this.messageMap.size();
			debugCode = size;
			this.messageMap.put(message, debugCode);
		}
		statisticMap.put(DEBUG, message);
		statisticMap.put(DEBUG_CODE, debugCode);
	}

	public String tabValueReport() {
		// tabKeyReport();
		this.recordMemory();
		this.sinceBegin();
		StringBuffer sbValue = new StringBuffer();
		Iterator<String> it = statisticMap.keySet().iterator();
		while (it.hasNext()) {
			String key = it.next();
			sbValue.append(statisticMap.get(key) + "\t"); //$NON-NLS-1$
		}
		String result = sbValue.toString();
		this.ps.println(result);
		return result;
	}

	public void countPackageFragmentCounters(int i) {
		this.nbOfReadPackageFragmentCounters += i;
	}

	public void countCompilationUnits(int i) {
		this.nbOfReadCompilationUnits += i;
	}

	public void newCompilationUnit(ITypeRoot cu) {
		this.incCompilationUnits();
		IPath location = cu.getResource().getLocation();
		File file = location.toFile();
		int nbLines = 0;
		try {
			BufferedReader bufferReader = new BufferedReader(new FileReader(
					file));
			for (nbLines = 0; bufferReader.readLine() != null; nbLines++) {
				;
			}
			bufferReader.close();
		} catch (Exception e) {
			Status status = new Status(IStatus.ERROR, JavaActivator.PLUGIN_ID,
					"Failed to count the CompilationUnit number of lines: ", e); //$NON-NLS-1$
			JavaActivator.getDefault().getLog().log(status);
			e.printStackTrace(System.err);
		}
		this.nbOfReadLines = this.nbOfReadLines + nbLines;
		statisticMap.put(NB_LINES, this.nbOfReadLines);
		this.tabValueReport("New cu"); //$NON-NLS-1$
	}

	public void countElements(Resource r) {
		this.tabValueReport("begin count elements"); //$NON-NLS-1$
		long nbElements = 0;
		TreeIterator<EObject> treeIter = r.getAllContents();
		while (treeIter.hasNext()) {
			treeIter.next();
			nbElements++;
		}
		statisticMap.put(NB_ELEMENTS, nbElements);
		this.tabValueReport("end count elements"); //$NON-NLS-1$
	}

	public void getMemoryInfo() {
	}

	public void begin() {
		try {
			this.properties.store(this.txtPrintStream, ""); //$NON-NLS-1$
		} catch (IOException e) {
			Status status = new Status(IStatus.ERROR, JavaActivator.PLUGIN_ID,
					e.getMessage(), e);
			JavaActivator.getDefault().getLog().log(status);
		}
		this.reset();
		this.tabKeyReport();
		this.begin = new Date().getTime();
		this.tabValueReport("Begin job"); //$NON-NLS-1$
	}

	public void end() {
		this.end = new Date().getTime();
		this.tabValueReport("end"); //$NON-NLS-1$
		try {
			this.txtPrintStream = new PrintStream(this.txtFile);
			this.properties.store(this.txtPrintStream, ""); //$NON-NLS-1$
		} catch (IOException e) {
			Status status = new Status(IStatus.ERROR, JavaActivator.PLUGIN_ID,
					e.getMessage(), e);
			JavaActivator.getDefault().getLog().log(status);
		}
		this.ps.close();
		this.txtPrintStream.close();
	}

	public void beginDiscovery() {
		this.beginDiscovery = new Date().getTime();
		this.tabValueReport("Ressource created and dicovery begining"); //$NON-NLS-1$
	}

	public void endDiscovery() {
		statisticMap.put(DISCOVERY, new Date().getTime() - this.beginDiscovery);
		this.tabValueReport("Dicovery finished"); //$NON-NLS-1$
	}

	public void beginSave() {
		this.beginSave = new Date().getTime();
		this.tabValueReport("Begin save"); //$NON-NLS-1$
	}

	public void endSave() {
		long save = (Long) statisticMap.get(SAVE);
		statisticMap.put(SAVE, save + (new Date().getTime() - this.beginSave));
		this.tabValueReport("End save"); //$NON-NLS-1$
	}

	public void beginFinalResolve() {
		this.beginFinalResolve = new Date().getTime();
		this.tabValueReport("beginFinalResolve"); //$NON-NLS-1$
	}

	public void endFinalResolve() {
		long endFinalResolve = new Date().getTime();
		Long finalResolve = (Long) statisticMap.get(FINAL_RESOLVE);
		statisticMap.put(FINAL_RESOLVE, finalResolve
				+ (endFinalResolve - this.beginFinalResolve));
		this.tabValueReport("endFinalResolve"); //$NON-NLS-1$
	}

	public void beginResolve() {
		this.beginResolve = new Date().getTime();
	}

	public void endResolve() {
		Long endResolve = new Date().getTime();
		Long totalResolv = (Long) statisticMap.get(TOTAL_RESOLVE);
		statisticMap.put(TOTAL_RESOLVE, totalResolv
				+ (endResolve - this.beginResolve));
	}

	public void incCompilationUnits() {
		Long nbCu = (Long) statisticMap.get(NB_COMPILATION_UNITS);
		nbCu++;
		statisticMap.put(NB_COMPILATION_UNITS, nbCu);
	}

	public static Statistics getSingleton() {
		if (singleton == null) {
			singleton = getStatistics(Activator.PLUGIN_ID + "_" //$NON-NLS-1$
					+ System.currentTimeMillis());
		}
		return singleton;
	}

	public static void resetSingleton() {
		singleton = getStatistics(Activator.PLUGIN_ID + "_" //$NON-NLS-1$
				+ System.currentTimeMillis());
	}

	public void newPackage(IPackageFragment parent) {
		// TODO Auto-generated method stub

	}

	// @Override
	public void sendMessage(Object message) {
		if (message instanceof String) {
			String stringMessage = (String) message;
			if (stringMessage.equals("Begin deep remove")) { //$NON-NLS-1$
				beginDeepRemove();
			}
		} else if (message instanceof String[]) {
			String[] message2 = (String[]) message;
			if (message2[0].equals("End deep remove")) { //$NON-NLS-1$
				endDeepRemove(message2[1]);
			}
		}

	}

	private final static String DEEP_REMOVE = "DEEP_REMOVE"; //$NON-NLS-1$
	private static final String MESSAGE = "MESSAGE"; //$NON-NLS-1$
	private long beginDeepRemove = 0;
	private Properties properties = new Properties();

	private void beginDeepRemove() {
		this.beginDeepRemove = new Date().getTime();
	}

	private void endDeepRemove(String objectDescription) {
		long deepRemove = (Long) statisticMap.get(DEEP_REMOVE);
		statisticMap.put(MESSAGE, objectDescription);
		statisticMap.put(DEEP_REMOVE, deepRemove
				+ (new Date().getTime() - this.beginDeepRemove));
		this.tabValueReport("Deep remove"); //$NON-NLS-1$

	}

	public Properties getProperties() {
		return this.properties;
	}

	public void beginInit() {
		this.beginInit = new Date().getTime();
	}

	public void endInit() {
		this.properties.put(Statistics.INIT_TIME, new Long(new Date().getTime()
				- this.beginInit).toString());

	}

}
