/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Bros (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.infra.browser.custom.editor.dialogs;

import java.util.Set;

import org.eclipse.emf.ecore.resource.Resource.Diagnostic;
import org.eclipse.gmt.modisco.infra.browser.custom.editor.Messages;
import org.eclipse.gmt.modisco.infra.browser.util.ImageProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/** A dialog to display a list of errors on EMF resources */
public class ErrorsDialog extends Dialog {
	private static final int LIST_MIN_WIDTH = 400;
	private static final int LIST_MIN_HEIGHT = 100;
	private final Set<Diagnostic> errors;

	public ErrorsDialog(final Shell parentShell, final Set<Diagnostic> allErrors) {
		super(parentShell);
		this.errors = allErrors;
	}

	@Override
	protected void configureShell(final Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.ErrorsDialog_errors);
		newShell.setImage(ImageProvider.getInstance().getMoDiscoIcon());
	}

	@Override
	protected Control createDialogArea(final Composite parent) {
		final Composite composite = (Composite) super.createDialogArea(parent);

		final ListViewer listViewer = new ListViewer(composite, SWT.BORDER | SWT.SINGLE
				| SWT.H_SCROLL | SWT.V_SCROLL);
		final GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData.minimumWidth = ErrorsDialog.LIST_MIN_WIDTH;
		gridData.minimumHeight = ErrorsDialog.LIST_MIN_HEIGHT;
		listViewer.getControl().setLayoutData(gridData);

		listViewer.setContentProvider(new IStructuredContentProvider() {
			@SuppressWarnings("unchecked")
			public Object[] getElements(final Object inputElement) {
				return ((Set<Diagnostic>) inputElement).toArray();
			}

			public void inputChanged(final Viewer viewer, final Object oldInput,
					final Object newInput) {
			}

			public void dispose() {
			}
		});

		listViewer.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(final Object element) {
				final Diagnostic diagnostic = (Diagnostic) element;
				return diagnostic.getMessage();
			}

			@Override
			public Image getImage(final Object element) {
				return ImageProvider.getInstance().getErrorIcon();
			}
		});
		listViewer.setInput(this.errors);

		final Text text = new Text(parent, SWT.BORDER | SWT.MULTI | SWT.READ_ONLY | SWT.H_SCROLL
				| SWT.V_SCROLL);
		final GridData gridData2 = new GridData(SWT.FILL, SWT.FILL, true, true);
		gridData2.minimumWidth = ErrorsDialog.LIST_MIN_WIDTH;
		gridData2.minimumHeight = ErrorsDialog.LIST_MIN_HEIGHT;
		text.setLayoutData(gridData2);

		listViewer.addSelectionChangedListener(new ISelectionChangedListener() {
			public void selectionChanged(final SelectionChangedEvent event) {
				final IStructuredSelection selection = (IStructuredSelection) event.getSelection();
				if (selection == null) {
					text.setText(""); //$NON-NLS-1$
					return;
				}
				final Diagnostic diagnostic = (Diagnostic) selection.getFirstElement();
				final String str = NLS.bind(Messages.ErrorsDialog_diagnosticMessage, new Object[] {
						diagnostic.getMessage(), diagnostic.getLocation(), diagnostic.getLine(),
						diagnostic.getColumn() });
				text.setText(str);
			}
		});

		return composite;
	}

	@Override
	protected void createButtonsForButtonBar(final Composite parent) {
		// only an OK button
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
	}

	@Override
	protected boolean isResizable() {
		return true;
	}
}
