/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire Dupe (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.client;

import java.util.Properties;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.Activator;
import org.eclipse.gmt.modisco.java.discoverer.benchmark.cdo.server.DerbyCDOServerNoAudits;
import org.eclipse.gmt.modisco.java.discoverer.tests.Server;
import org.eclipse.gmt.modisco.java.discoverer.tests.emfstat.Statistics;
import org.eclipse.jdt.core.IJavaProject;

public class JavaDiscovererCDOWithoutTrace extends JavaDiscovererCDO {

	private static final long SLEEP_TIME = 20000;

	@Override
	protected Statistics getStatistics(final IJavaProject javaProject) {
		return null;
	}

	@Override
	protected Resource getResource(final String resourceName,
			final IJavaProject javaProject) {
		try {
			IStatus status = new Status(IStatus.INFO, Activator.PLUGIN_ID,
					"Starting server: " //$NON-NLS-1$
							+ DerbyCDOServerNoAudits.class.getSimpleName());
			Activator.getDefault().getLog().log(status);
			Server server = new DerbyCDOServerNoAudits();
			server.start("db" + System.currentTimeMillis(), this.getPort()); //$NON-NLS-1$
			// ILaunch iLaunch = launch(serverClass.getSimpleName(), port);
			Thread.sleep(JavaDiscovererCDOWithoutTrace.SLEEP_TIME);
			IStatus status2 = new Status(IStatus.INFO, Activator.PLUGIN_ID,
					"Starting discovery"); //$NON-NLS-1$
			Activator.getDefault().getLog().log(status2);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return super.getResource(resourceName, javaProject);
	}

	@Override
	protected Properties getProperties() {
		Properties properties = super.getProperties();
		properties.put(ALGO_VARIANTE, Messages.JavaDiscovererCDOWithoutTrace_0);
		return properties;
	}
}
