/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire Dupe (Mia-Software) - initial API and implementation
 *     Fabien Giquel (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.modisco.java.discoverer.benchmark.emf.client;

import java.util.Properties;

import org.eclipse.gmt.modisco.java.discoverer.tests.emfstat.DiscoverJavaModelFromJavaProjectEMFStat;
import org.eclipse.gmt.modisco.java.discoverer.tests.emfstat.JavaReaderEMFStat;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.io.java.JavaReader;

public class JavaDiscovererIncrementalClassicalEMF extends
		DiscoverJavaModelFromJavaProjectEMFStat {
	@Override
	protected JavaReader getJavaReader(final boolean isIncremental) {
		JavaReaderEMFStat javaReader = new JavaReaderEMFStat(getEFactory(),
				true);
		javaReader.setStatistics(this.statistics);
		return javaReader;
	}

	@Override
	protected Properties getProperties() {
		Properties properties = super.getProperties();
		properties.put(ALGO_VARIANTE, Messages.JavaDiscoverIncrementalClassicalEMF_0);
		properties.put(MM_VARIANTE, "Classic EObject"); //$NON-NLS-1$
		return properties;
	}

	@Override
	protected JavaFactory getEFactory() {
		return org.eclipse.gmt.modisco.java.emf.classic.JavaFactory.eINSTANCE;
	}
}
